 <?php
require_once 'connection.php';
$conn = Database::connect();

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $fullname = trim($_POST['fullname'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $password = trim($_POST['password'] ?? '');
    $confirm_password = trim($_POST['confirm_password'] ?? '');
    $terms = isset($_POST['terms']) ? 1 : 0;
    $filter = $_POST['filter'] ?? ''; // user or agent

    if (empty($fullname) || empty($email) || empty($password) || empty($confirm_password) || empty($filter)) {
        echo "<script>alert('⚠ Please fill in all required fields.'); history.back();</script>";
        exit;
    }

    if ($password !== $confirm_password) {
        echo "<script>alert('❌ Passwords do not match!'); history.back();</script>";
        exit;
    }

    if (!$terms) {
        echo "<script>alert('⚠ You must agree to the Terms & Conditions.'); history.back();</script>";
        exit;
    }

    $hashed_password = password_hash($password, PASSWORD_BCRYPT);

    try {
        $check = $conn->prepare("SELECT id FROM signin WHERE email = :email");
        $check->execute([':email' => $email]);
        if ($check->rowCount() > 0) {
            echo "<script>alert('⚠ Email already registered!'); history.back();</script>";
            exit;
        }

        // ✅ Save as pending (for both user & agent)
        $sql = "INSERT INTO signin (fullname, email, password, terms, filter, status) 
                VALUES (:fullname, :email, :password, :terms, :filter, 'pending')";
        $stmt = $conn->prepare($sql);
        $stmt->execute([
            ':fullname' => $fullname,
            ':email' => $email,
            ':password' => $hashed_password,
            ':terms' => $terms,
            ':filter' => $filter
        ]);

        echo "<script>
            alert('✅ Account created successfully! Pending admin approval.');
            window.location.href='pending.php';
        </script>";
    } catch (PDOException $e) {
        echo "<script>alert('❌ Error: " . addslashes($e->getMessage()) . "');</script>";
    }
}


$filter = $_GET['filter'] ?? 'all';

if ($filter === 'user' || $filter === 'agent') {
    $stmt = $conn->prepare("SELECT * FROM signin WHERE filter = :filter");
    $stmt->execute([':filter' => $filter]);
} else {
    $stmt = $conn->query("SELECT * FROM signin");
}

$users = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>


<?php
// signin.php
session_start();

// DB connection (adjust path if you use a different file)
// $host = 'localhost';
// $db   = 'applyjobs';
// $user = 'root';
// $pass = '';
// $charset = 'utf8mb4';

// $dsn = "mysql:host=$host;dbname=$db;charset=$charset";
// $options = [
//     PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
//     PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
//     PDO::ATTR_EMULATE_PREPARES   => false,
// ];

// try {
//     $pdo = new PDO($dsn, $user, $pass, $options);
// } catch (PDOException $e) {
//     exit("DB connection failed: " . $e->getMessage());
// }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $fullname = trim($_POST['fullname'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $confirm = $_POST['confirm_password'] ?? '';
    $terms = isset($_POST['terms']) ? 1 : 0;
    $filter = $_POST['filter'] ?? ''; // 'user' or 'agent'

    // Basic validation
    if (!$fullname || !$email || !$password || !$confirm || !$filter) {
        $_SESSION['error'] = "Please fill all required fields.";
        header('Location: login.php');
        exit;
    }
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $_SESSION['error'] = "Invalid email address.";
        header('Location: login.php');
        exit;
    }
    if ($password !== $confirm) {
        $_SESSION['error'] = "Passwords do not match.";
        header('Location: login.php');
        exit;
    }
    if (!$terms) {
        $_SESSION['error'] = "You must agree to Terms & Conditions.";
        header('Location: login.php');
        exit;
    }

    // Check email uniqueness
    $stmt = $pdo->prepare("SELECT id FROM signin WHERE email = :email LIMIT 1");
    $stmt->execute([':email' => $email]);
    if ($stmt->fetch()) {
        $_SESSION['error'] = "Email already registered.";
        header('Location: login.php');
        exit;
    }

    // Insert as pending and not allowed (allow=0)
    $hashed = password_hash($password, PASSWORD_BCRYPT);
    $sql = "INSERT INTO signin (fullname, email, password, terms, filter, status, allow, login_count)
            VALUES (:fullname, :email, :password, :terms, :filter, 'pending', 0, 0)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':fullname' => $fullname,
        ':email'    => $email,
        ':password' => $hashed,
        ':terms'    => $terms,
        ':filter'   => $filter
    ]);

    $_SESSION['success'] = "Account created. Pending admin approval.";
    header('Location: pending.php'); // or signin.php with message
    exit;
}
?>
<!-- (Your existing HTML form for signup goes here; unchanged) -->





<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <?php include 'winTab.php' ?>
    <title>Sign up</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .logo {
    display: flex;
    align-items: center;
}

.logo img {
    margin-top: 5px;
    height: 50px; /* Adjust as needed */
    width: auto;
    max-width: 200px; /* Prevent logo from being too wide */
}

.text-logo {
    font-size: 1.5rem;
    font-weight: bold;
    color: #333; /* Adjust color to match your design */
    text-decoration: none;
}

/* For responsive design */
@media (max-width: 768px) {
    .logo img {
        height: 35px;
    }
    
    .text-logo {
        font-size: 1.3rem;
    }
}

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        :root {
            --primary: #3b82f6;
            --secondary: #1e40af;
            --accent: #60a5fa;
            --dark: #0f172a;
            --darker: #020617;
            --light: #f8fafc;
            --text: #cbd5e1;
            --text-dark: #94a3b8;
            --success: #10b981;
            --card-bg: #1e293b;
            --header-bg: rgba(15, 23, 42, 0.95);
            --footer-bg: #020617;
        }

        [data-theme="light"] {
            --primary: #3b82f6;
            --secondary: #1e40af;
            --accent: #60a5fa;
            --dark: #f1f5f9;
            --darker: #e2e8f0;
            --light: #0f172a;
            --text: #334155;
            --text-dark: #475569;
            --success: #10b981;
            --card-bg: #ffffff;
            --header-bg: rgba(255, 255, 255, 0.95);
            --footer-bg: #e2e8f0;
        }

        body {
            background: linear-gradient(135deg, var(--darker), var(--dark));
            color: var(--text);
            line-height: 1.6;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            transition: background 0.3s ease, color 0.3s ease;
        }

        .container {
            width: 90%;
            max-width: 1200px;
            margin: 0 auto;
        }

        /* Header & Navigation */
        header {
            background: var(--header-bg);
            color: var(--text);
            padding: 1rem 0;
            position: sticky;
            top: 0;
            z-index: 1000;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            backdrop-filter: blur(10px);
            transition: background 0.3s ease;
        }

        
        /* Theme Toggle */
        .theme-toggle {
            background: transparent;
            border: none;
            color: var(--text);
            cursor: pointer;
            font-size: 1.2rem;
            padding: 0.5rem;
            border-radius: 50%;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .theme-toggle:hover {
            background: rgba(255, 255, 255, 0.1);
            transform: rotate(30deg);
        }

        .theme-toggle .fa-sun {
            display: none;
        }

        [data-theme="light"] .theme-toggle .fa-sun {
            display: block;
        }

        [data-theme="light"] .theme-toggle .fa-moon {
            display: none;
        }

        /* Sign In Section */
        .signin-section {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 3rem 0;
        }

        .signin-container {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 4rem;
            align-items: center;
            max-width: 1000px;
            width: 100%;
        }

        .signin-info {
            padding: 2rem;
        }

        .signin-info h1 {
            font-size: 2.5rem;
            color: var(--light);
            margin-bottom: 1.5rem;
            line-height: 1.3;
        }

        .signin-info p {
            font-size: 1.1rem;
            margin-bottom: 2rem;
            color: var(--text);
        }

        .features-list {
            list-style: none;
            margin-top: 2rem;
        }

        .features-list li {
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .features-list i {
            color: var(--success);
            font-size: 1.2rem;
        }

        .signin-form-container {
            background: var(--card-bg);
            border-radius: 15px;
            padding: 3rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.05);
            position: relative;
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .signin-form-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 4px;
            background: var(--primary);
        }

        .form-header {
            text-align: center;
            margin-bottom: 2rem;
        }

        .form-header h2 {
            font-size: 2rem;
            color: var(--light);
            margin-bottom: 0.5rem;
        }

        .form-header p {
            color: var(--text);
        }

        .signin-form {
            display: flex;
            flex-direction: column;
            gap: 1.5rem;
        }

        .form-group {
            display: flex;
            flex-direction: column;
            gap: 0.5rem;
        }
        .usertype {
            flex-direction: row;
            align-items: center;
        }

        .form-group label {
            color: var(--light);
            font-weight: 500;
        }

        .input-with-icon {
            position: relative;
        }

        .input-with-icon i {
            position: absolute;
            left: 1rem;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-dark);
        }

        .form-control {
            width: 100%;
            padding: 1rem 1rem 1rem 3rem;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            color: var(--text);
            font-size: 1rem;
            transition: all 0.3s ease;
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 2px rgba(59, 130, 246, 0.2);
        }

        .form-options {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1rem;
        }

        .remember-me {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .remember-me input {
            accent-color: var(--primary);
        }

        .forgot-password {
            color: var(--primary);
            text-decoration: none;
            font-size: 0.9rem;
            transition: all 0.3s ease;
        }

        .forgot-password:hover {
            color: var(--accent);
            text-decoration: underline;
        }

        .btn-signin-form {
            background: var(--primary);
            color: white;
            border: none;
            padding: 1rem;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            font-size: 1rem;
            margin-top: 0.5rem;
        }

        .btn-signin-form:hover {
            background: var(--secondary);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(59, 130, 246, 0.4);
        }

        .divider {
            display: flex;
            align-items: center;
            margin: 1.5rem 0;
            color: var(--text-dark);
        }

        .divider::before,
        .divider::after {
            content: '';
            flex: 1;
            height: 1px;
            background: rgba(255, 255, 255, 0.1);
        }

        .divider span {
            padding: 0 1rem;
            font-size: 0.9rem;
        }

        .social-signin {
            display: flex;
            gap: 1rem;
            margin-bottom: 1.5rem;
        }

        .btn-social {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            padding: 0.8rem;
            border-radius: 8px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
            border: 1px solid rgba(255, 255, 255, 0.1);
            background: rgba(255, 255, 255, 0.05);
            color: var(--text);
        }

        .btn-social:hover {
            background: rgba(255, 255, 255, 0.1);
            transform: translateY(-2px);
        }

        .btn-google {
            color: #ea4335;
        }

        .btn-linkedin {
            color: #0a66c2;
        }

        .login-link {
            text-align: center;
            margin-top: 1.5rem;
            color: var(--text);
        }

        .login-link a {
            color: var(--primary);
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .login-link a:hover {
            color: var(--accent);
            text-decoration: underline;
        }

        /* Footer */
        footer {
            background: var(--footer-bg);
            color: var(--text);
            padding: 2rem 0 1rem;
            border-top: 1px solid rgba(255, 255, 255, 0.05);
            margin-top: auto;
            transition: background 0.3s ease;
        }

        .footer-content {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 2rem;
            margin-bottom: 2rem;
        }

        .footer-column h3 {
            font-size: 1.2rem;
            margin-bottom: 1rem;
            position: relative;
            padding-bottom: 10px;
            color: var(--light);
        }

        .footer-column h3::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 40px;
            height: 3px;
            background: var(--primary);
        }

        .footer-links {
            list-style: none;
        }

        .footer-links li {
            margin-bottom: 0.8rem;
        }

        .footer-links a {
            color: var(--text-dark);
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .footer-links a:hover {
            color: var(--light);
            padding-left: 5px;
        }

        .social-links {
            display: flex;
            gap: 1rem;
            margin-top: 1rem;
        }

        .social-links a {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.05);
            border-radius: 50%;
            color: var(--text);
            transition: all 0.3s ease;
        }

        .social-links a:hover {
            background: var(--primary);
            color: white;
            transform: translateY(-3px);
        }

        .footer-bottom {
            text-align: center;
            padding-top: 1.5rem;
            border-top: 1px solid rgba(255, 255, 255, 0.05);
            color: var(--text-dark);
            font-size: 0.9rem;
        }

        /* Animations */
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        @keyframes slideUp {
            from { 
                opacity: 0;
                transform: translateY(30px);
            }
            to { 
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Responsive Design */
        @media (max-width: 992px) {
            .signin-container {
                grid-template-columns: 1fr;
                gap: 3rem;
            }
            
            .signin-info {
                text-align: center;
            }
        }

       
    </style>
</head>
<body>
      <!-- Header -->
<?php  include 'header.php'; ?>
    <!-- Sign In Section -->
    <section class="signin-section">
        <div class="container">
            <div class="signin-container">
                <div class="signin-info">
                    <h1>Start Your Career Journey With Us</h1>
                    <p>Create an account to access thousands of job opportunities, track your applications, and get personalized recommendations.</p>
                    
                    <ul class="features-list">
                        <li>
                            <i class="fas fa-check-circle"></i>
                            <span>Personalized job recommendations</span>
                        </li>
                        <li>
                            <i class="fas fa-check-circle"></i>
                            <span>One-click application process</span>
                        </li>
                        <li>
                            <i class="fas fa-check-circle"></i>
                            <span>Track all your applications</span>
                        </li>
                        <li>
                            <i class="fas fa-check-circle"></i>
                            <span>Get matched with top employers</span>
                        </li>
                    </ul>
                </div>
                
                <div class="signin-form-container">
                    <div class="form-header">
                        <h2>Create Account</h2>
                        <p>Fill in your details to get started</p>
                    </div>
                    
       <form class="signin-form" id="signinForm" method="POST" action="signup.php" >
    <div class="form-group">
        <label for="fullname">Full Name</label>
        <div class="input-with-icon">
            <i class="fas fa-user"></i>
            <input type="text" id="fullname" name="fullname" class="form-control" placeholder="Enter your full name" required>
        </div>
    </div>
    

    <div class="form-group">
        <label for="email">Email Address</label>
        <div class="input-with-icon">
            <i class="fas fa-envelope"></i>
            <input type="email" id="email" name="email" class="form-control" placeholder="Enter your email" required>
        </div>
    </div>
<div class="form-group usertype">
  <label class="required">Select Type:</label><br>
  <label><input type="radio" name="filter" value="user" required> User</label>
  <label style="margin-left:15px;"><input type="radio" name="filter" value="agent"> Agent</label>
</div>

    <div class="form-group">
        <label for="password">Password</label>
        <div class="input-with-icon">
            <i class="fas fa-lock"></i>
            <input type="password" id="password" name="password" class="form-control" placeholder="Create a password" required>
        </div>
    </div>

    <div class="form-group">
        <label for="confirm-password">Confirm Password</label>
        <div class="input-with-icon">
            <i class="fas fa-lock"></i>
            <input type="password" id="confirm-password" name="confirm_password" class="form-control" placeholder="Confirm your password" required>
        </div>
    </div>

    <div class="form-options">
        <div class="remember-me">
            <input type="checkbox" id="terms" name="terms" required>
            <label for="terms">I agree to the <a href="#" style="color: var(--primary);">Terms & Conditions</a></label>
        </div>
    </div>

    <button type="submit" class="btn-signin-form">Create Account</button>
</form>


                    
                    <div class="divider">
                        <span>Or sign up with</span>
                    </div>
                    
                    <div class="social-signin">
                        <button class="btn-social btn-google">
                            <i class="fab fa-google"></i>
                            <span>Google</span>
                        </button>
                        <button class="btn-social btn-linkedin">
                            <i class="fab fa-linkedin"></i>
                            <span>LinkedIn</span>
                        </button>
                    </div>
                    
                    <div class="login-link">
                        <p>Already have an account? <a href="login.php">Log in now</a></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
   <?php  include 'footer.php'; ?>


    <script>
        // Theme Toggle Functionality
        const themeToggle = document.getElementById('themeToggle');
        const prefersDarkScheme = window.matchMedia('(prefers-color-scheme: dark)');
        
        // Check for saved theme preference or use device preference
        const currentTheme = localStorage.getItem('theme') || 
                            (prefersDarkScheme.matches ? 'dark' : 'light');
        
        // Set initial theme
        document.documentElement.setAttribute('data-theme', currentTheme);
        
        // Toggle theme on button click
        themeToggle.addEventListener('click', function() {
            const currentTheme = document.documentElement.getAttribute('data-theme');
            const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
            
            document.documentElement.setAttribute('data-theme', newTheme);
            localStorage.setItem('theme', newTheme);
        });

        // Simple animation on scroll
        document.addEventListener('DOMContentLoaded', function() {
            const animatedElements = document.querySelectorAll('.signin-info, .signin-form-container');
            
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.style.opacity = '1';
                        entry.target.style.transform = 'translateY(0)';
                    }
                });
            }, { threshold: 0.1 });
            
            animatedElements.forEach(el => {
                el.style.opacity = '0';
                el.style.transform = 'translateY(20px)';
                el.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
                observer.observe(el);
            });

            // Sign In Form Submission
            const signinForm = document.getElementById('signinForm');
            // signinForm.addEventListener('submit', function(e) {
            //     e.preventDefault();
                
            //     // Get form values
            //     const fullname = document.getElementById('fullname').value;
            //     const email = document.getElementById('email').value;
            //     const password = document.getElementById('password').value;
            //     const confirmPassword = document.getElementById('confirm-password').value;
            //     const terms = document.getElementById('terms').checked;
                
            //     // Simple validation
            //     if (!fullname || !email || !password || !confirmPassword) {
            //         alert('Please fill in all required fields.');
            //         return;
            //     }
                
            //     if (password !== confirmPassword) {
            //         alert('Passwords do not match. Please try again.');
            //         return;
            //     }
                
            //     if (!terms) {
            //         alert('Please agree to the Terms & Conditions.');
            //         return;
            //     }
                
            //     // Show success message (in a real app, this would be an API call)
            //     alert(`Welcome to CareerConnect, ${fullname}! Your account has been created successfully.`);
                
            //     // In a real application, you would redirect to the dashboard
            //     // window.location.href = 'dashboard.html';
            // });

            // Social Sign In Buttons
            const socialButtons = document.querySelectorAll('.btn-social');
            socialButtons.forEach(button => {
                button.addEventListener('click', () => {
                    const platform = button.querySelector('span').textContent;
                    alert(`You've chosen to sign up with ${platform}. This would redirect you to their authentication service.`);
                });
            });
        });


function validateForm() {
    let name = document.getElementById("fullname").value.trim();
    let email = document.getElementById("email").value.trim();
    let password = document.getElementById("password").value.trim();
    let confirm = document.getElementById("confirm-password").value.trim();
    let terms = document.getElementById("terms").checked;

    if (name === "" || email === "" || password === "" || confirm === "") {
        alert("⚠ Please fill all fields.");
        return false;
    }

    if (password !== confirm) {
        alert("❌ Passwords do not match!");
        return false;
    }

    if (!terms) {
        alert("⚠ Please agree to the Terms & Conditions.");
        return false;
    }

    return true; // Allow form to submit
}




    </script>
</body>
</html>