<?php
session_start();
require_once 'connection.php'; // include your PDO connection file

$conn = Database::connect();

// Check login and role
if (!isset($_SESSION['user_id']) || !isset($_SESSION['filter'])) {
    header('Location: login.php');
    exit;
}

// Only agents can access post.php
if ($_SESSION['filter'] !== 'agent') {
    echo "<script>alert('You do not have permission to access this page.'); window.location='index.php';</script>";
    exit;
}


// Handle form submission
if ($_SERVER["REQUEST_METHOD"] === "POST") {

    // Sanitize inputs
    $jobTitle         = trim($_POST['jobTitle'] ?? '');
    $companyName      = trim($_POST['companyName'] ?? '');
    $jobLocation      = trim($_POST['jobLocation'] ?? '');
    $jobType          = trim($_POST['jobType'] ?? '');
    $salaryRange      = trim($_POST['salaryRange'] ?? '');
    $jobCategory      = trim($_POST['jobCategory'] ?? '');
    $jobDescription   = trim($_POST['jobDescription'] ?? '');
    $qualifications   = trim($_POST['qualifications'] ?? '');
    $applicationEmail = trim($_POST['applicationEmail'] ?? '');
    $featuredJob      = isset($_POST['featuredJob']) ? 1 : 0;

    // Validate required fields
    if (empty($jobTitle) || empty($companyName) || empty($jobLocation) ||
        empty($jobType) || empty($jobCategory) || empty($jobDescription) || empty($applicationEmail)) {
        echo "<script>alert('⚠ Please fill in all required fields.');</script>";
    } else {
        try {
            $sql = "INSERT INTO jobs (
                        job_title, company_name, job_location, job_type, salary_range,
                        job_category, job_description, qualifications, email, featured, allow, created_at
                    ) VALUES (
                        :jobTitle, :companyName, :jobLocation, :jobType, :salaryRange,
                        :jobCategory, :jobDescription, :qualifications, :applicationEmail, :featuredJob, 0, NOW()
                    )";

            $stmt = $conn->prepare($sql);
            $stmt->bindParam(':jobTitle', $jobTitle);
            $stmt->bindParam(':companyName', $companyName);
            $stmt->bindParam(':jobLocation', $jobLocation);
            $stmt->bindParam(':jobType', $jobType);
            $stmt->bindParam(':salaryRange', $salaryRange);
            $stmt->bindParam(':jobCategory', $jobCategory);
            $stmt->bindParam(':jobDescription', $jobDescription);
            $stmt->bindParam(':qualifications', $qualifications);
            $stmt->bindParam(':applicationEmail', $applicationEmail);
            $stmt->bindParam(':featuredJob', $featuredJob, PDO::PARAM_INT);

            $stmt->execute();

            echo "<script>alert('✅ Job posted successfully! It is pending admin approval.'); window.location='post.php';</script>";
        } catch (PDOException $e) {
            echo "<script>alert('❌ Database Error: " . addslashes($e->getMessage()) . "');</script>";
        }
    }
}
?>





<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Post Job</title>
      <?php include 'winTab.php' ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        :root {
            --primary: #3b82f6;
            --secondary: #1e40af;
            --accent: #60a5fa;
            --dark: #0f172a;
            --darker: #020617;
            --light: #f8fafc;
            --text: #ffffffff;
            --text-dark: #94a3b8;
            --success: #10b981;
            --card-bg: #1e293b;
            --header-bg: rgba(15, 23, 42, 0.95);
            --footer-bg: #020617;
        }

        [data-theme="light"] {
            --primary: #3b82f6;
            --secondary: #1e40af;
            --accent: #60a5fa;
            --dark: #f1f5f9;
            --darker: #e2e8f0;
            --light: #0f172a;
            --text: #334155;
            --text-dark: #475569;
            --success: #10b981;
            --card-bg: #ffffff;
            --header-bg: rgba(255, 255, 255, 0.95);
            --footer-bg: #e2e8f0;
        }

        body {
            background: linear-gradient(135deg, var(--darker), var(--dark));
            color: var(--text);
            line-height: 1.6;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            transition: background 0.3s ease, color 0.3s ease;
        }

        .container {
            width: 90%;
            max-width: 1200px;
            margin: 0 auto;
        }

        /* Header & Navigation */
        header {
            background: var(--header-bg);
            color: var(--text);
            padding: 1rem 0;
            position: sticky;
            top: 0;
            z-index: 1000;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            backdrop-filter: blur(10px);
            transition: background 0.3s ease;
        }

        

        /* Theme Toggle */
        .theme-toggle {
            background: transparent;
            border: none;
            color: var(--text);
            cursor: pointer;
            font-size: 1.2rem;
            padding: 0.5rem;
            border-radius: 50%;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .theme-toggle:hover {
            background: rgba(255, 255, 255, 0.1);
            transform: rotate(30deg);
        }

        .theme-toggle .fa-sun {
            display: none;
        }

        [data-theme="light"] .theme-toggle .fa-sun {
            display: block;
        }

        [data-theme="light"] .theme-toggle .fa-moon {
            display: none;
        }

        /* Post Job Section - COMPACT VERSION */
        .post-job-section {
            flex: 1;
            padding: 1.5rem 0;
        }

        .section-header {
            text-align: center;
            margin-bottom: 1.5rem;
        }

        .section-header h1 {
            font-size: 1.8rem;
            color: var(--light);
            margin-bottom: 0.4rem;
            line-height: 1.2;
        }

        .section-header p {
            font-size: 0.9rem;
            color: var(--text);
            max-width: 500px;
            margin: 0 auto;
        }

        .post-job-container {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 2rem;
            align-items: start;
            max-width: 1000px;
            width: 100%;
            margin: 0 auto;
        }

        .job-info {
            padding: 1.2rem;
            background: var(--card-bg);
            border-radius: 10px;
            box-shadow: 0 6px 15px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.05);
            position: relative;
            overflow: hidden;
        }

        .job-info::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 3px;
            background: var(--primary);
        }

        .job-info h2 {
            font-size: 1.3rem;
            color: var(--light);
            margin-bottom: 0.8rem;
        }

        .job-info p {
            font-size: 0.85rem;
            line-height: 1.4;
            margin-bottom: 0.8rem;
        }

        .benefits-list {
            list-style: none;
            margin-top: 1.2rem;
        }

        .benefits-list li {
            margin-bottom: 0.6rem;
            display: flex;
            align-items: center;
            gap: 0.6rem;
            font-size: 0.85rem;
        }

        .benefits-list i {
            color: var(--success);
            font-size: 0.9rem;
            flex-shrink: 0;
        }

        .job-form-container {
            background: var(--card-bg);
            border-radius: 10px;
            padding: 1.5rem;
            box-shadow: 0 6px 15px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.05);
            position: relative;
            overflow: hidden;
        }

        .job-form-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 3px;
            background: var(--primary);
        }

        .form-header {
            text-align: center;
            margin-bottom: 1.2rem;
        }

        .form-header h2 {
            font-size: 1.4rem;
            color: var(--light);
            margin-bottom: 0.3rem;
        }

        .form-header p {
            color: var(--text);
            font-size: 0.85rem;
        }

        .job-form {
            display: flex;
            flex-direction: column;
            gap: 1rem;
        }

        .form-group {
            display: flex;
            flex-direction: column;
            gap: 0.3rem;
        }

        .form-group label {
            color: var(--light);
            font-weight: 500;
            font-size: 0.85rem;
        }

        .input-with-icon {
            position: relative;
        }

        .input-with-icon i {
            position: absolute;
            left: 0.7rem;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-dark);
            font-size: 0.8rem;
        }

        .form-control {
            width: 100%;
            padding: 0.7rem 0.7rem 0.7rem 2.2rem;
            background: rgba(30, 41, 59, 1);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 5px;
            color: var(--text);
            font-size: 0.85rem;
            transition: all 0.3s ease;
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 2px rgba(59, 130, 246, 0.2);
        }

        textarea.form-control {
            min-height: 80px;
            resize: vertical;
            padding-left: 0.7rem;
            font-size: 0.8rem;
        }

        /* Company Name and Job Title in one line */
        .form-row-compact {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 0.7rem;
        }

        /* Job Description and Qualifications in one line */
        .form-row-textarea {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 0.7rem;
        }

        /* Regular form rows for other fields */
        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 0.7rem;
        }

        .form-options {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 0.3rem;
        }

        .checkbox-group {
            display: flex;
            align-items: center;
            gap: 0.4rem;
            font-size: 0.8rem;
        }

        .checkbox-group input {
            accent-color: var(--primary);
            transform: scale(0.8);
        }

        /* Image Upload Styles */
        .image-upload-container {
            display: flex;
            flex-direction: column;
            gap: 0.6rem;
        }

        .image-upload-area {
            border: 2px dashed var(--text-dark);
            border-radius: 5px;
            padding: 1rem;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            background: rgba(255, 255, 255, 0.02);
        }

        .image-upload-area:hover {
            border-color: var(--primary);
            background: rgba(59, 130, 246, 0.05);
        }

        .image-upload-area i {
            font-size: 1.6rem;
            color: var(--text-dark);
            margin-bottom: 0.6rem;
        }

        .image-upload-area p {
            margin-bottom: 0.3rem;
            font-size: 0.8rem;
        }

        .image-upload-area span {
            font-size: 0.75rem;
            color: var(--text-dark);
        }

        .image-preview {
            display: none;
            margin-top: 0.6rem;
            text-align: center;
        }

        .image-preview img {
            max-width: 100%;
            max-height: 120px;
            border-radius: 5px;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.2);
        }

        .remove-image {
            margin-top: 0.4rem;
            background: #ef4444;
            color: white;
            border: none;
            padding: 0.3rem 0.6rem;
            border-radius: 3px;
            cursor: pointer;
            transition: all 0.3s ease;
            font-size: 0.75rem;
        }

        .remove-image:hover {
            background: #dc2626;
        }

        /* Footer */
        footer {
            background: var(--footer-bg);
            color: var(--text);
            padding: 2rem 0 1rem;
            border-top: 1px solid rgba(255, 255, 255, 0.05);
            margin-top: auto;
            transition: background 0.3s ease;
        }

        .footer-content {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 2rem;
            margin-bottom: 2rem;
        }

        .footer-column h3 {
            font-size: 1.2rem;
            margin-bottom: 1rem;
            position: relative;
            padding-bottom: 10px;
            color: var(--light);
        }

        .footer-column h3::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 40px;
            height: 3px;
            background: var(--primary);
        }

        .footer-links {
            list-style: none;
        }

        .footer-links li {
            margin-bottom: 0.8rem;
        }

        .footer-links a {
            color: var(--text-dark);
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .footer-links a:hover {
            color: var(--light);
            padding-left: 5px;
        }

        .social-links {
            display: flex;
            gap: 1rem;
            margin-top: 1rem;
        }

        .social-links a {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.05);
            border-radius: 50%;
            color: var(--text);
            transition: all 0.3s ease;
        }

        .social-links a:hover {
            background: var(--primary);
            color: white;
            transform: translateY(-3px);
        }

        .footer-bottom {
            text-align: center;
            padding-top: 1.5rem;
            border-top: 1px solid rgba(255, 255, 255, 0.05);
            color: var(--text-dark);
            font-size: 0.9rem;
        }

        /* Animations */
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        @keyframes slideUp {
            from { 
                opacity: 0;
                transform: translateY(30px);
            }
            to { 
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Responsive Design */
        @media (max-width: 992px) {
            .post-job-container {
                grid-template-columns: 1fr;
                gap: 1.5rem;
            }
            
            .job-info {
                text-align: center;
            }
        }

        @media (max-width: 768px) {
            .post-job-section {
                padding: 1rem 0;
            }
            
            .section-header {
                margin-bottom: 1rem;
            }
            
            .section-header h1 {
                font-size: 1.6rem;
            }
            
            .job-form-container {
                padding: 1rem;
            }
            
            .form-row-compact,
            .form-row-textarea,
            .form-row {
                grid-template-columns: 1fr;
            }
            
            .image-upload-area {
                padding: 0.8rem;
            }
            
            .image-upload-area i {
                font-size: 1.4rem;
                margin-bottom: 0.4rem;
            }

        }
    </style>
</head>
<body>
     <!-- Header -->
<?php  include 'header.php'; ?>
    <!-- Post Job Section -->
    <section class="post-job-section">
        <div class="container">
            <div class="section-header">
                <h1>Post a Job Opportunity</h1>
                <p>Reach thousands of qualified candidates and find the perfect fit for your organization</p>
            </div>
            
            <div class="post-job-container">
                <div class="job-info">
                    <h2>Why Post on Work and Workers?</h2>
                    <p>Work and Workers isn't just another job board—it's a specialized ecosystem of professionals actively seeking new opportunities. Unlike generic platforms where your posting might get lost in a sea of irrelevant applications, our advanced matching algorithm ensures your job reaches candidates with the specific skills, experience, and career aspirations that align with your requirements. This targeted approach means you spend less time sifting through unqualified applications and more time engaging with serious contenders.</p>
                    
                    <ul class="benefits-list">
                        <li>
                            <i class="fas fa-check-circle"></i>
                            <span>Access to thousands of active job seekers</span>
                        </li>
                        <li>
                            <i class="fas fa-check-circle"></i>
                            <span>Advanced candidate matching technology</span>
                        </li>
                        <li>
                            <i class="fas fa-check-circle"></i>
                            <span>Easy application management dashboard</span>
                        </li>
                        <li>
                            <i class="fas fa-check-circle"></i>
                            <span>Dedicated employer support team</span>
                        </li>
                        <li>
                            <i class="fas fa-check-circle"></i>
                            <span>Performance analytics and insights</span>
                        </li>
                    </ul>
                </div>
                
                <div class="job-form-container">
                    <div class="form-header">
                        <h2>Job Details</h2>
                        <p>Fill in the information about your job opening</p>
                    </div>
                    
                  
                    <form class="job-form" id="jobForm" method="POST" action="post.php" enctype="multipart/form-data">

                        <!-- Job Title and Company Name in one line -->
                        <div class="form-row-compact">
                            <div class="form-group">
                                <label for="jobTitle">Job Title *</label>
                                <div class="input-with-icon">
                                    <i class="fas fa-briefcase"></i>
                                    <input type="text" id="jobTitle"  name="jobTitle" class="form-control" placeholder="e.g. Senior Web Developer" required>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label for="companyName">Company Name *</label>
                                <div class="input-with-icon">
                                    <i class="fas fa-building"></i>
                                    <input type="text" id="companyName" name="companyName" class="form-control" placeholder="Your company name" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="jobLocation">Job Location *</label>
                            <div class="input-with-icon">
                                <i class="fas fa-map-marker-alt"></i>
                                <input type="text" id="jobLocation" name="jobLocation" class="form-control" placeholder="City, State or Remote" required>
                            </div>
                        </div>
                        
                        <div class="form-row">
                            <div class="form-group">
                                <label for="jobType">Job Type *</label>
                                <select id="jobType" name="jobType" class="form-control" required>
                                    <option value="">Select job type</option>
                                    <option value="full-time" name="full-time">Full-time</option>
                                    <option value="part-time">Part-time</option>
                                    <option value="contract">Contract</option>
                                    <option value="temporary">Temporary</option>
                                    <option value="internship">Internship</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label for="salaryRange">Salary Range</label>
                                <div class="input-with-icon">
                                    <i class="fas fa-pkr-sign"></i>
                                    <input type="text" id="salaryRange" name="salaryRange" class="form-control" placeholder="e.g. 60,000 - 80,000">
                                </div>
                            </div>
                        </div>
                        
                       <div class="form-group">
    <label for="jobCategory">Job Category *</label>
    <select id="jobCategory" name="jobCategory" class="form-control" required>
        <option value="">Select category</option>
        <option value="security" name="Security">Security</option>
        <option value="housemate" name="housemate" >Housemate</option>
        <option value="factory">Factory</option>
        <option value="accounting">Accounting</option>
        <option value="development">Development</option>
        <option value="it">IT</option>
        <option value="labor">Labour</option>
        <option value="healthcare">Healthcare</option>
        <option value="engineering">Engineering & Technical</option>
        <option value="education">Education & Training</option>
        <option value="callcenter">Call Center Agent</option>
        <option value="ecommerce">E-commerce & Retail</option>
        <option value="marketing">Marketing & Sales</option>
        <option value="dataentry">Data Entry Operator</option>
    </select>
</div>

                        
                        <!-- Job Description and Qualifications in one line -->
                        <div class="form-row-textarea">
                            <div class="form-group">
                                <label for="jobDescription">Job Description *</label>
                                <textarea id="jobDescription" name="jobDescription" class="form-control" placeholder="Describe the role, responsibilities, and requirements..." required></textarea>
                            </div>
                            
                            <div class="form-group">
                                <label for="qualifications">Required Qualifications</label>
                                <textarea id="qualifications" name="qualifications" class="form-control" placeholder="List the required skills, education, and experience..."></textarea>
                            </div>
                        </div>
           
                        
                        <div class="form-group">
                            <label for="applicationEmail">Application Email *</label>
                            <div class="input-with-icon">
                                <i class="fas fa-envelope"></i>
                                <input type="email" id="applicationEmail" name="applicationEmail" class="form-control" placeholder="Email to receive applications" required>
                            </div>
                        </div>
                        
                        <div class="form-options">
                            <div class="checkbox-group">
                                <input type="checkbox" name="featuredJob" id="featuredJob">
                                <label for="featuredJob">Feature this job (additional cost)</label>
                            </div>
                        </div>
                        
                        <button type="submit" class="btn-primary">Post Job</button>
                    </form>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
   <?php  include 'footer.php'; ?>



    

    <script>
        // Theme Toggle Functionality
        const themeToggle = document.getElementById('themeToggle');
        const prefersDarkScheme = window.matchMedia('(prefers-color-scheme: dark)');
        
        // Check for saved theme preference or use device preference
        const currentTheme = localStorage.getItem('theme') || 
                            (prefersDarkScheme.matches ? 'dark' : 'light');
        
        // Set initial theme
        document.documentElement.setAttribute('data-theme', currentTheme);
        
        // Toggle theme on button click
        themeToggle.addEventListener('click', function() {
            const currentTheme = document.documentElement.getAttribute('data-theme');
            const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
            
            document.documentElement.setAttribute('data-theme', newTheme);
            localStorage.setItem('theme', newTheme);
        });

        // Image Upload Functionality
        document.addEventListener('DOMContentLoaded', function() {
            const imageUploadArea = document.getElementById('imageUploadArea');
            const companyLogoInput = document.getElementById('companyLogo');
            const imagePreview = document.getElementById('imagePreview');
            const previewImage = document.getElementById('previewImage');
            const removeImageBtn = document.getElementById('removeImage');
            
          
            
            // Simple animation on scroll
            const animatedElements = document.querySelectorAll('.job-info, .job-form-container');
            
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.style.opacity = '1';
                        entry.target.style.transform = 'translateY(0)';
                    }
                });
            }, { threshold: 0.1 });
            
            animatedElements.forEach(el => {
                el.style.opacity = '0';
                el.style.transform = 'translateY(20px)';
                el.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
                observer.observe(el);
            });

            
        });
    </script>
</body>
</html>