<?php
// ================= DB CONNECTION =================

require_once 'connection.php'; // include your conn connection file

// ✅ Ensure you have a $conn (conn)
$conn = Database::connect();


// Check login
// if (!isset($_SESSION['user_id'])) {
//     header('Location: login.php');
//     exit;
// }


// ================= HANDLE DELETE =================
if (isset($_GET['delete_id'])) {
    $delete_id = intval($_GET['delete_id']);
    $stmt = $conn->prepare("DELETE FROM jobs WHERE allow = 1 AND id = ?");
    $stmt->execute([$delete_id]);
    header("Location: postjob.php?msg=Job deleted successfully");
    exit;
}

// ================= HANDLE UPDATE =================
if (isset($_POST['update'])) {
    $id = intval($_POST['id']);
    $company_name = $_POST['company_name'];
    $job_title = $_POST['job_title'];
    $job_type = $_POST['job_type'];
    $job_category = $_POST['job_category'];
    $salary_range = $_POST['salary_range'];
    $job_location = $_POST['job_location'];
    $job_description = $_POST['job_description'];
    $email = $_POST['email'];

    $stmt = $conn->prepare("UPDATE jobs SET company_name = ?, job_title = ?, job_type = ?, job_category = ?, salary_range = ?, job_location=?, job_description = ?, email = ? WHERE id = ?");
    $stmt->execute([$company_name, $job_title, $job_type, $job_category, $salary_range, $job_location, $job_description, $email, $id]);
    header("Location: postjob.php?msg=Job updated successfully");
    exit;
}





// ================= FETCH JOBS =================



// Fetch approved jobs
$jobs = $conn->query("SELECT * FROM jobs WHERE allow = 1 ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);

// Organize by category
$categories = [];
foreach ($jobs as $job) {
    $cat = strtolower($job['job_category'] ?? 'others');
    if (!isset($categories[$cat])) {
        $categories[$cat] = [];
    }
    $categories[$cat][] = $job;
}

// ================= FETCH JOBS BASED ON SEARCH OR CATEGORY =================

$where = " WHERE allow = 1 ";
$params = [];

// If category search
if (!empty($_GET['category'])) {
    $where .= " AND LOWER(job_category) = ? ";
    $params[] = strtolower($_GET['category']);
}

// If keyword search
if (!empty($_GET['keyword'])) {
    $where .= " AND (job_title LIKE ? OR company_name LIKE ? OR job_category LIKE ?) ";
    $keyword = "%" . $_GET['keyword'] . "%";
    $params[] = $keyword;
    $params[] = $keyword;
    $params[] = $keyword;
}

// If location search
if (!empty($_GET['location'])) {
    $where .= " AND job_location LIKE ? ";
    $params[] = "%" . $_GET['location'] . "%";
}

$sql = "SELECT * FROM jobs $where ORDER BY id DESC";
$stmt = $conn->prepare($sql);
$stmt->execute($params);
$jobs = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Organize by categories
$categories = [];
foreach ($jobs as $job) {
    $cat = strtolower($job['job_category']);
    $categories[$cat][] = $job;
}



// foreach($jobs as $job) {
//     echo "<div class='job-card'>";
//     echo "<h3>{$job['job_title']}</h3>";
//     echo "<p>{$job['company_name']}</p>";
//     echo "<p>{$job['job_location']}</p>";
//     echo "<p>{$job['job_type']}</p>";
//     echo "</div>";
// }
$categories = [];
foreach ($jobs as $job) {
    $cat = strtolower($job['job_category'] ?? 'others');
    if (!isset($categories[$cat])) {
        $categories[$cat] = [];
    }
    $categories[$cat][] = $job;
}

?>











<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <?php include 'winTab.php' ?>
    <title>Job Listings</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .logo {
            display: flex;
            align-items: center;
        }

        .logo img {
            margin-top: 5px;
            height: 50px;
            /* Adjust as needed */
            width: auto;
            max-width: 200px;
            /* Prevent logo from being too wide */
        }

        .text-logo {
            font-size: 1.5rem;
            font-weight: bold;
            color: #333;
            /* Adjust color to match your design */
            text-decoration: none;
        }

        /* For responsive design */
        @media (max-width: 768px) {
            .logo img {
                height: 35px;
            }

            .text-logo {
                font-size: 1.3rem;
            }
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        :root {
            --primary: #3b82f6;
            --secondary: #1e40af;
            --accent: #60a5fa;
            --dark: #0f172a;
            --darker: #020617;
            --light: #f8fafc;
            --text: #cbd5e1;
            --text-dark: #94a3b8;
            --success: #10b981;
            --card-bg: #1e293b;
        }

        /* Light mode variables */
        [data-theme="light"] {
            --primary: #3b82f6;
            --secondary: #1e40af;
            --accent: #60a5fa;
            --dark: #f1f5f9;
            --darker: #e2e8f0;
            --light: #0f172a;
            --text: #334155;
            --text-dark: #475569;
            --success: #10b981;
            --card-bg: #ffffff;
        }

        body {
            background: linear-gradient(135deg, var(--darker), var(--dark));
            color: var(--text);
            line-height: 1.6;
            overflow-x: hidden;
            transition: all 0.3s ease;
        }

        .container {
            width: 90%;
            max-width: 1200px;
            margin: 0 auto;
        }

        /* Header & Navigation */
        header {
            background: rgba(15, 23, 42, 0.95);
            color: white;
            padding: 1rem 0;
            position: sticky;
            top: 0;
            z-index: 1000;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
            backdrop-filter: blur(10px);
            transition: all 0.3s ease;
        }

        [data-theme="light"] header {
            background: rgba(255, 255, 255, 0.95);
            color: var(--text);
        }

        

        /* Theme Toggle Button */
        .theme-toggle {
            background: transparent;
            border: none;
            color: var(--text);
            cursor: pointer;
            font-size: 1.2rem;
            padding: 0.5rem;
            border-radius: 50%;
            transition: all 0.3s ease;
        }

        .theme-toggle:hover {
            background: rgba(255, 255, 255, 0.1);
        }

        [data-theme="light"] .theme-toggle:hover {
            background: rgba(0, 0, 0, 0.05);
        }

        /* Page Header */
        .page-header {
            background: linear-gradient(rgba(15, 23, 42, 0.85), rgba(2, 6, 23, 0.9)), url('https://images.unsplash.com/photo-1586281380349-632531db7ed4?ixlib=rb-4.0.3&auto=format&fit=crop&w=1950&q=80');
            background-size: cover;
            background-position: center;
            color: white;
            padding: 4rem 0;
            text-align: center;
        }

        [data-theme="light"] .page-header {
            background: linear-gradient(rgba(255, 255, 255, 0.85), rgba(226, 232, 240, 0.9)), url('https://images.unsplash.com/photo-1586281380349-632531db7ed4?ixlib=rb-4.0.3&auto=format&fit=crop&w=1950&q=80');
            color: var(--text);
        }

        .page-header h1 {
            font-size: 3rem;
            margin-bottom: 1rem;
        }

        .page-header p {
            font-size: 1.2rem;
            max-width: 700px;
            margin: 0 auto;
            opacity: 0.9;
        }

        /* Job Categories Navigation */
        .categories-nav {
            background: var(--card-bg);
            padding: 1.5rem 0;
            position: sticky;
            top: 80px;
            z-index: 999;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
        }

        .categories-container {
            display: flex;
            gap: 1rem;
            overflow-x: auto;
            padding-bottom: 0.5rem;
               scrollbar-width: thin;
    scrollbar-color: rgba(59, 130, 246, 0.5) rgba(0,0,0,0.05);
        }

        .category-tab {
            background: rgba(255, 255, 255, 0.05);
            color: var(--text);
            border: none;
            padding: 0.8rem 1.5rem;
            border-radius: 50px;
            cursor: pointer;
            transition: all 0.3s ease;
            white-space: nowrap;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        [data-theme="light"] .category-tab {
            background: rgba(0, 0, 0, 0.05);
        }

        .category-tab:hover {
            background: rgba(59, 130, 246, 0.2);
            color: var(--primary);
        }

        .category-tab.active {
            background: var(--primary);
            color: white;
        }

        /* Webkit Browsers (Chrome, Safari, Edge) */
.categories-container::-webkit-scrollbar {
    height: 8px; /* Horizontal scrollbar height */
}

.categories-container::-webkit-scrollbar-track {
    background: rgba(0,0,0,0.05); /* Track background */
    border-radius: 4px;
}

.categories-container::-webkit-scrollbar-thumb {
    background: rgba(59, 130, 246, 0.5); /* Thumb color */
    border-radius: 4px;
    transition: all 0.3s ease;
}

.categories-container::-webkit-scrollbar-thumb:hover {
    background: rgba(59, 130, 246, 0.8); /* Hover effect */
}


        /* Job Listings */
        .job-listings {
            padding: 3rem 0;
        }

        .job-category {
            margin-bottom: 4rem;
            animation: fadeIn 0.5s ease;
        }

        .category-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 2rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        [data-theme="light"] .category-header {
            border-bottom: 1px solid rgba(0, 0, 0, 0.1);
        }

        .category-title {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .category-icon {
            width: 50px;
            height: 50px;
            background: rgba(59, 130, 246, 0.1);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            color: var(--primary);
        }

        .category-title h2 {
            font-size: 2rem;
            color: white;
        }

        [data-theme="light"] .category-title h2 {
            color: var(--text);
        }

        .job-count {
            background: var(--primary);
            color: white;
            padding: 0.3rem 0.8rem;
            border-radius: 50px;
            font-size: 0.9rem;
            font-weight: 600;
        }

        .jobs-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
            gap: 1.5rem;
        }

        .job-card {
            background: var(--card-bg);
            border-radius: 10px;
            padding: 1.5rem;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            transition: all 0.3s ease;
            border: 1px solid rgba(255, 255, 255, 0.05);
            display: flex;
            flex-direction: column;
        }

        [data-theme="light"] .job-card {
            border: 1px solid rgba(0, 0, 0, 0.05);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
        }

        .job-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.3);
        }

        [data-theme="light"] .job-card:hover {
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
        }

        .job-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 1rem;
        }

        .job-title {
            font-size: 1.2rem;
            color: white;
            margin-bottom: 0.5rem;
        }

        [data-theme="light"] .job-title {
            color: var(--text);
        }

        .job-company {
            color: var(--text-dark);
            font-size: 0.9rem;
        }

        .job-type {
            background: rgba(59, 130, 246, 0.2);
            color: var(--primary);
            padding: 0.3rem 0.8rem;
            border-radius: 50px;
            font-size: 0.8rem;
            font-weight: 600;
        }

        .job-details {
            display: flex;
            gap: 1rem;
            margin-bottom: 1.5rem;
            flex-wrap: wrap;
        }

        .job-detail {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: var(--text-dark);
            font-size: 0.9rem;
        }

        .job-detail i {
            color: var(--primary);
        }

        .job-description {
            margin-bottom: 1.5rem;
            color: var(--text);
            font-size: 0.95rem;
            flex-grow: 1;
        }

        .job-footer {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: auto;
        }

        .job-salary {
            color: white;
            font-weight: 600;
        }

        [data-theme="light"] .job-salary {
            color: var(--text);
        }

        .btn-apply {
            background: var(--primary);
            color: white;
            border: none;
            padding: 0.7rem 1.5rem;
            border-radius: 50px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }

        .btn-apply:hover {
            background: var(--secondary);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(59, 130, 246, 0.4);
        }

        /* View More Section */
        .view-more {
            text-align: center;
            margin-top: 2rem;
        }

        .btn-view-more {
            background: transparent;
            color: var(--primary);
            border: 2px solid var(--primary);
            padding: 0.8rem 2rem;
            border-radius: 50px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .btn-view-more:hover {
            background: var(--primary);
            color: white;
        }

        /* Footer */
        footer {
            background: var(--darker);
            color: white;
            padding: 4rem 0 2rem;
            border-top: 1px solid rgba(255, 255, 255, 0.05);
            transition: all 0.3s ease;
        }

        [data-theme="light"] footer {
            color: var(--text);
            border-top: 1px solid rgba(0, 0, 0, 0.05);
        }

        .footer-content {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 3rem;
            margin-bottom: 3rem;
        }

        .footer-column h3 {
            font-size: 1.3rem;
            margin-bottom: 1.5rem;
            position: relative;
            padding-bottom: 10px;
            color: white;
        }

        [data-theme="light"] .footer-column h3 {
            color: var(--text);
        }

        .footer-column h3::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 40px;
            height: 3px;
            background: var(--primary);
        }

        .footer-links {
            list-style: none;
        }

        .footer-links li {
            margin-bottom: 0.8rem;
        }

        .footer-links a {
            color: var(--text-dark);
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .footer-links a:hover {
            color: white;
            padding-left: 5px;
        }

        [data-theme="light"] .footer-links a:hover {
            color: var(--text);
        }

        .social-links {
            display: flex;
            gap: 1rem;
            margin-top: 1.5rem;
        }

        .social-links a {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.05);
            border-radius: 50%;
            color: var(--text);
            transition: all 0.3s ease;
        }

        [data-theme="light"] .social-links a {
            background: rgba(0, 0, 0, 0.05);
        }

        .social-links a:hover {
            background: var(--primary);
            color: white;
            transform: translateY(-3px);
        }

        .footer-bottom {
            text-align: center;
            padding-top: 2rem;
            border-top: 1px solid rgba(255, 255, 255, 0.05);
            color: var(--text-dark);
            font-size: 0.9rem;
        }

        [data-theme="light"] .footer-bottom {
            border-top: 1px solid rgba(0, 0, 0, 0.05);
        }

        /* Animations */
        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        /* Responsive Design */
        @media (max-width: 992px) {
            .jobs-grid {
                grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            }
        }

    
    </style>
</head>

<body>
    <!-- Header -->
    <?php include 'header.php'; ?>

    <!-- Page Header -->
    <section class="page-header">
        <div class="container">
            <h1>Job Listings</h1>
            <p>Browse through thousands of job opportunities across various industries and find your perfect match</p>
        </div>
    </section>

    <!-- Job Categories Navigation -->
    <section class="categories-nav">
        <div class="container">
            <div class="categories-container">
                <button class="category-tab active" data-category="all">All Jobs</button>
                <button class="category-tab" data-category="security"><i class="fas fa-shield-alt"></i> Security</button>
                <button class="category-tab" data-category="housemate"><i class="fas fa-home"></i> Housemate</button>
                <button class="category-tab" data-category="factory"><i class="fas fa-industry"></i> Factory</button>
                <button class="category-tab" data-category="accounting"><i class="fas fa-calculator"></i> Accounting</button>
                <button class="category-tab" data-category="development"><i class="fas fa-laptop-code"></i> Development</button>
                <button class="category-tab" data-category="it"><i class="fas fa-network-wired"></i> IT</button>
                <button class="category-tab" data-category="labor"><i class="fas fa-hard-hat"></i> Labour</button>
                <button class="category-tab" data-category="healthcare"><i class="fas fa-heartbeat"></i> Healthcare</button>
                <button class="category-tab" data-category="engineering"><i class="fas fa-cogs"></i> Engineering & Technical</button>
                <button class="category-tab" data-category="education"><i class="fas fa-graduation-cap"></i> Education & Training</button>
                <button class="category-tab" data-category="callcenter"><i class="fas fa-headset"></i> Call Center Agent</button>
                <button class="category-tab" data-category="ecommerce"><i class="fas fa-shopping-cart"></i> E-commerce & Retail</button>
                <button class="category-tab" data-category="marketing"><i class="fas fa-chart-line"></i> Marketing & Sales</button>
                <button class="category-tab" data-category="dataentry"><i class="fas fa-keyboard"></i> Data Entry Operator</button>
            </div>
        </div>
    </section>

    <!-- Job Listings -->
    <section class="job-listings">
        <div class="container">
            <?php if (!empty($categories)): ?>
                <?php foreach ($categories as $category => $categoryJobs): ?>
                    <div class="job-category" id="<?= htmlspecialchars($category); ?>">
                        <div class="category-header">
                            <div class="category-title">
                                <div class="category-icon">
                                    <?php
                                    $icons = [
                                        'security' => 'fa-shield-alt',
                                        'housemate' => 'fa-home',
                                        'factory' => 'fa-industry',
                                        'accounting' => 'fa-calculator',
                                        'development' => 'fa-laptop-code',
                                        'it' => 'fa-network-wired',
                                        'labor' => 'fa-hard-hat',
                                        'healthcare' => 'fa-heartbeat',
                                        'engineering' => 'fa-cogs',
                                        'education' => 'fa-graduation-cap',
                                        'callcenter' => 'fa-headset',
                                        'ecommerce' => 'fa-shopping-cart',
                                        'marketing' => 'fa-chart-line',
                                        'dataentry' => 'fa-keyboard'
                                    ];
                                    $icon = $icons[$category] ?? 'fa-briefcase';
                                    ?>
                                    <i class="fas <?= $icon; ?>"></i>
                                </div>
                                <h2><?= ucfirst($category); ?> Jobs</h2>
                            </div>
                            <span class="job-count"><?= count($categoryJobs); ?> Jobs</span>
                        </div>

                        <div class="jobs-grid">
                            <?php foreach ($categoryJobs as $job): ?>
                                <div class="job-card">
                                    <div class="job-header">
                                        <div>
                                            <h3 class="job-title"><?= htmlspecialchars($job['job_title']); ?></h3>
                                            <p class="job-company"><?= htmlspecialchars($job['company_name']); ?></p>
                                        </div>
                                        <span class="job-type"><?= htmlspecialchars($job['job_type']); ?></span>
                                    </div>

                                    <div class="job-details">
                                        <div class="job-detail">
                                            <i class="fas fa-map-marker-alt"></i>
                                            <span><?= htmlspecialchars($job['job_location'] ?? 'Not specified'); ?></span>
                                        </div>
                                        <div class="job-detail">
                                            <i class="fas fa-clock"></i>
                                            <span>Posted recently</span>
                                        </div>
                                    </div>

                                    <p class="job-description">
                                        <?= htmlspecialchars($job['job_description'] ?? 'No description provided.'); ?>
                                    </p>

                                    <div class="job-footer">
                                        <div class="job-salary">
                                            <?= htmlspecialchars($job['salary_range'] ?? 'N/A'); ?>
                                        </div>
                                        <form action="apply.php" >
                                            <!-- <input type="hidden" name="job_id" value="<?= $job['id']; ?>"> -->
                                            <button  type="submit" class="btn btn-primary">Apply Now</button>
                                        </form>

                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>

                        <div class="view-more">
                            <button class="btn-view-more">View All <?= ucfirst($category); ?> Jobs</button>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p>No jobs available at the moment.</p>
            <?php endif; ?>
        </div>
    </section>
    <?php include 'footer.php'; ?>



    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Category tab functionality
            const categoryTabs = document.querySelectorAll('.category-tab');
            const jobCategories = document.querySelectorAll('.job-category');

            categoryTabs.forEach(tab => {
                tab.addEventListener('click', () => {
                    const category = tab.getAttribute('data-category');

                    // Update active tab
                    categoryTabs.forEach(t => t.classList.remove('active'));
                    tab.classList.add('active');

                    // Show/hide job categories
                    if (category === 'all') {
                        jobCategories.forEach(cat => {
                            cat.style.display = 'block';
                        });
                    } else {
                        jobCategories.forEach(cat => {
                            if (cat.id === category) {
                                cat.style.display = 'block';
                            } else {
                                cat.style.display = 'none';
                            }
                        });
                    }

                    // Scroll to the first visible category
                    const firstVisible = document.querySelector('.job-category[style="display: block"]');
                    if (firstVisible) {
                        firstVisible.scrollIntoView({
                            behavior: 'smooth',
                            block: 'start'
                        });
                    }
                });
            });

            // Apply button functionality
            const applyButtons = document.querySelectorAll('.btn-apply');
            applyButtons.forEach(button => {
                button.addEventListener('click', () => {
                    const jobTitle = button.closest('.job-card').querySelector('.job-title').textContent;
                    const company = button.closest('.job-card').querySelector('.job-company').textContent;
                    alert(`Application submitted for ${jobTitle} at ${company}! Our team will review your application shortly.`);
                });
            });

            // View more buttons
            const viewMoreButtons = document.querySelectorAll('.btn-view-more');
            viewMoreButtons.forEach(button => {
                button.addEventListener('click', () => {
                    const category = button.closest('.job-category').id;
                    alert(`Loading more ${category} jobs...`);
                    
                    // In a real application, this would load more jobs via AJAX or navigate to a dedicated page
                });
            });

            // Theme toggle functionality
            const themeToggle = document.getElementById('themeToggle');
            const themeIcon = themeToggle.querySelector('i');

            // Check for saved theme preference or default to dark
            const currentTheme = localStorage.getItem('theme') || 'dark';
            document.documentElement.setAttribute('data-theme', currentTheme);

            // Update icon based on current theme
            if (currentTheme === 'light') {
                themeIcon.classList.remove('fa-moon');
                themeIcon.classList.add('fa-sun');
            } else {
                themeIcon.classList.remove('fa-sun');
                themeIcon.classList.add('fa-moon');
            }

            themeToggle.addEventListener('click', () => {
                const currentTheme = document.documentElement.getAttribute('data-theme');
                const newTheme = currentTheme === 'dark' ? 'light' : 'dark';

                // Update theme
                document.documentElement.setAttribute('data-theme', newTheme);
                localStorage.setItem('theme', newTheme);

                // Update icon
                if (newTheme === 'light') {
                    themeIcon.classList.remove('fa-moon');
                    themeIcon.classList.add('fa-sun');
                } else {
                    themeIcon.classList.remove('fa-sun');
                    themeIcon.classList.add('fa-moon');
                }
            });
        });
    </script>
</body>

</html>