<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
   <?php include 'winTab.php' ?>
    <title>Home</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        :root {
            --primary: #3b82f6;
            --secondary: #1e40af;
            --accent: #60a5fa;
            --dark: #0f172a;
            --darker: #020617;
            --light: #f8fafc;
            --text: #cbd5e1;
            --text-dark: #94a3b8;
            --success: #10b981;
            --card-bg: #1e293b;
        }

        /* Light mode variables */
        [data-theme="light"] {
            --primary: #3b82f6;
            --secondary: #1e40af;
            --accent: #60a5fa;
            --dark: #f1f5f9;
            --darker: #e2e8f0;
            --light: #0f172a;
            --text: #334155;
            --text-dark: #475569;
            --success: #10b981;
            --card-bg: #ffffff;
        }

        body {
            background: linear-gradient(135deg, var(--darker), var(--dark));
            color: var(--text);
            line-height: 1.6;
            overflow-x: hidden;
            transition: all 0.3s ease;
        }

        .container {
            width: 90%;
            max-width: 1200px;
            margin: 0 auto;
        }

        /* Header & Navigation */
        header {
            background: rgba(15, 23, 42, 0.95);
            color: white;
            padding: 1rem 0;
            position: sticky;
            top: 0;
            z-index: 1000;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
            backdrop-filter: blur(10px);
            transition: all 0.3s ease;
        }

        [data-theme="light"] header {
            background: rgba(255, 255, 255, 0.95);
            color: var(--text);
        }

        

        /* Theme Toggle Button */
        .theme-toggle {
            background: transparent;
            border: none;
            color: var(--text);
            cursor: pointer;
            font-size: 1.2rem;
            padding: 0.5rem;
            border-radius: 50%;
            transition: all 0.3s ease;
        }

        .theme-toggle:hover {
            background: rgba(255, 255, 255, 0.1);
        }

        [data-theme="light"] .theme-toggle:hover {
            background: rgba(0, 0, 0, 0.05);
        }

        /* Hero Section */
        .hero {
            background: linear-gradient(rgba(15, 23, 42, 0.85), rgba(2, 6, 23, 0.9)), url('https://images.unsplash.com/photo-1521791136064-7986c2920216?ixlib=rb-4.0.3&auto=format&fit=crop&w=1950&q=80');
            background-size: cover;
            background-position: center;
            color: white;
            padding: 8rem 0;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        [data-theme="light"] .hero {
            background: linear-gradient(rgba(255, 255, 255, 0.85), rgba(226, 232, 240, 0.9)), url('https://images.unsplash.com/photo-1521791136064-7986c2920216?ixlib=rb-4.0.3&auto=format&fit=crop&w=1950&q=80');
            color: var(--text);
        }

        .hero-content {
            max-width: 800px;
            margin: 0 auto;
            animation: slideUp 1s ease;
        }

        .hero h1 {
            font-size: 3.5rem;
            margin-bottom: 1.5rem;
            line-height: 1.2;
            text-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);
        }

        .hero p {
            font-size: 1.2rem;
            margin-bottom: 2rem;
            opacity: 0.9;
        }

        .search-box {
            display: flex;
            max-width: 600px;
            margin: 0 auto;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        [data-theme="light"] .search-box {
            background: rgba(0, 0, 0, 0.05);
            border: 1px solid rgba(0, 0, 0, 0.1);
        }

        .search-box input {
            flex: 1;
            padding: 1.2rem 1.5rem;
            border: none;
            outline: none;
            font-size: 1rem;
            background: transparent;
            color: white;
        }

        [data-theme="light"] .search-box input {
            color: var(--text);
        }

        .search-box input::placeholder {
            color: rgba(255, 255, 255, 0.7);
        }

        [data-theme="light"] .search-box input::placeholder {
            color: rgba(0, 0, 0, 0.5);
        }

        .search-box button {
            background: var(--primary);
            color: white;
            border: none;
            padding: 0 2rem;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .search-box button:hover {
            background: var(--secondary);
        }

        /* About Section */
        .about {
            padding: 5rem 0;
            background: var(--darker);
            transition: all 0.3s ease;
        }

        .section-title {
            text-align: center;
            margin-bottom: 3rem;
        }

        .section-title h2 {
            font-size: 2.5rem;
            color: white;
            margin-bottom: 1rem;
            position: relative;
            display: inline-block;
        }

        [data-theme="light"] .section-title h2 {
            color: var(--text);
        }

        .section-title h2::after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 4px;
            background: var(--primary);
            border-radius: 2px;
        }

        .section-title p {
            max-width: 700px;
            margin: 0 auto;
            color: var(--text);
        }

        .about-content {
            display: flex;
            align-items: center;
            gap: 4rem;
        }

        .about-text {
            flex: 1;
        }

        .about-text h3 {
            font-size: 1.8rem;
            margin-bottom: 1.5rem;
            color: white;
        }

        [data-theme="light"] .about-text h3 {
            color: var(--text);
        }

        .about-text p {
            margin-bottom: 1.5rem;
            color: var(--text);
        }

        .about-stats {
            display: flex;
            gap: 2rem;
            margin-top: 2rem;
        }

        .stat {
            text-align: center;
        }

        .stat h4 {
            font-size: 2.5rem;
            color: var(--primary);
            margin-bottom: 0.5rem;
        }

        .stat p {
            color: var(--text-dark);
        }

        .about-image {
            flex: 1;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.3);
            animation: float 3s ease-in-out infinite;
        }

        [data-theme="light"] .about-image {
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
        }

        .about-image img {
            width: 100%;
            height: auto;
            display: block;
        }

        /* Job Categories */
        .categories {
            padding: 5rem 0;
            background: var(--dark);
            transition: all 0.3s ease;
        }

        .categories-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 2rem;
        }

        .category-card {
            background: var(--card-bg);
            border-radius: 10px;
            padding: 2rem;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            transition: all 0.3s ease;
            cursor: pointer;
            border: 1px solid rgba(255, 255, 255, 0.05);
            position: relative;
            overflow: hidden;
        }

        [data-theme="light"] .category-card {
            border: 1px solid rgba(0, 0, 0, 0.05);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
        }

        .category-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 4px;
            background: var(--primary);
            transform: scaleX(0);
            transition: transform 0.3s ease;
        }

        .category-card:hover::before {
            transform: scaleX(1);
        }

        .category-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.3);
        }

        [data-theme="light"] .category-card:hover {
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
        }

        .category-icon {
            width: 70px;
            height: 70px;
            background: rgba(59, 130, 246, 0.1);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem;
            font-size: 1.8rem;
            color: var(--primary);
        }

        .category-card h3 {
            margin-bottom: 1rem;
            color: white;
        }

        [data-theme="light"] .category-card h3 {
            color: var(--text);
        }

        .category-card p {
            color: var(--text);
            font-size: 0.9rem;
            margin-bottom: 1.5rem;
        }

        .btn-apply {
            background: var(--primary);
            color: white;
            border: none;
            padding: 0.7rem 1.5rem;
            border-radius: 50px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }

        .btn-apply:hover {
            background: var(--secondary);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(59, 130, 246, 0.4);
        }

        /* Job Listings Section */
        .job-listings {
            padding: 5rem 0;
            background: var(--darker);
            transition: all 0.3s ease;
        }

        .job-filters {
            display: flex;
            gap: 1rem;
            margin-bottom: 2rem;
            flex-wrap: wrap;
        }

        .filter-btn {
            background: var(--card-bg);
            color: var(--text);
            border: 1px solid rgba(255, 255, 255, 0.1);
            padding: 0.5rem 1.5rem;
            border-radius: 50px;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        [data-theme="light"] .filter-btn {
            border: 1px solid rgba(0, 0, 0, 0.1);
        }

        .filter-btn.active,
        .filter-btn:hover {
            background: var(--primary);
            color: white;
        }

        .job-cards {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
            gap: 2rem;
        }

        .job-card {
            background: var(--card-bg);
            border-radius: 10px;
            padding: 1.5rem;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            transition: all 0.3s ease;
            border: 1px solid rgba(255, 255, 255, 0.05);
            display: flex;
            flex-direction: column;
        }

        [data-theme="light"] .job-card {
            border: 1px solid rgba(0, 0, 0, 0.05);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
        }

        .job-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.3);
        }

        [data-theme="light"] .job-card:hover {
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
        }

        .job-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 1rem;
        }

        .job-title {
            font-size: 1.2rem;
            color: white;
            margin-bottom: 0.5rem;
        }

        [data-theme="light"] .job-title {
            color: var(--text);
        }

        .job-company {
            color: var(--text-dark);
            font-size: 0.9rem;
        }

        .job-type {
            background: rgba(59, 130, 246, 0.2);
            color: var(--primary);
            padding: 0.3rem 0.8rem;
            border-radius: 50px;
            font-size: 0.8rem;
            font-weight: 600;
        }

        .job-details {
            display: flex;
            gap: 1rem;
            margin-bottom: 1.5rem;
            flex-wrap: wrap;
        }

        .job-detail {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: var(--text-dark);
            font-size: 0.9rem;
        }

        .job-detail i {
            color: var(--primary);
        }

        .job-footer {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: auto;
        }

        .job-salary {
            color: white;
            font-weight: 600;
        }

        [data-theme="light"] .job-salary {
            color: var(--text);
        }

        /* CTA Section */
        .cta {
            background: linear-gradient(135deg, var(--primary), var(#1a1b1c));
            color: white;
            padding: 5rem 0;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .cta::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: url('https://images.unsplash.com/photo-1552664730-d307ca884978?ixlib=rb-4.0.3&auto=format&fit=crop&w=1000&q=80');
            background-size: cover;
            background-position: center;
            opacity: 0.1;
        }

        .cta h2 {
            font-size: 2.5rem;
            margin-bottom: 1.5rem;
            position: relative;
        }

        .cta p {
            max-width: 700px;
            margin: 0 auto 2rem;
            font-size: 1.1rem;
            position: relative;
        }

        .btn-cta {
            background: #fbbf24;
            color: var(--dark);
            padding: 1rem 2.5rem;
            font-size: 1.1rem;
            border-radius: 50px;
            display: inline-block;
            transition: all 0.3s ease;
            position: relative;
            font-weight: 600;
            text-decoration: none;
        }

        .btn-cta:hover {
            background: #f59e0b;
            transform: translateY(-3px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
        }

        /* Footer */
        footer {
            background: var(--darker);
            color: white;
            padding: 4rem 0 2rem;
            border-top: 1px solid rgba(255, 255, 255, 0.05);
            transition: all 0.3s ease;
        }

        [data-theme="light"] footer {
            color: var(--text);
            border-top: 1px solid rgba(0, 0, 0, 0.05);
        }

        .footer-content {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 3rem;
            margin-bottom: 3rem;
        }

        .footer-column h3 {
            font-size: 1.3rem;
            margin-bottom: 1.5rem;
            position: relative;
            padding-bottom: 10px;
            color: white;
        }

        [data-theme="light"] .footer-column h3 {
            color: var(--text);
        }

        .footer-column h3::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 40px;
            height: 3px;
            background: var(--primary);
        }

        .footer-links {
            list-style: none;
        }

        .footer-links li {
            margin-bottom: 0.8rem;
        }

        .footer-links a {
            color: var(--text-dark);
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .footer-links a:hover {
            color: white;
            padding-left: 5px;
        }

        [data-theme="light"] .footer-links a:hover {
            color: var(--text);
        }

        .social-links {
            display: flex;
            gap: 1rem;
            margin-top: 1.5rem;
        }

        .social-links a {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.05);
            border-radius: 50%;
            color: var(--text);
            transition: all 0.3s ease;
        }

        [data-theme="light"] .social-links a {
            background: rgba(0, 0, 0, 0.05);
        }

        .social-links a:hover {
            background: var(--primary);
            color: white;
            transform: translateY(-3px);
        }

        .footer-bottom {
            text-align: center;
            padding-top: 2rem;
            border-top: 1px solid rgba(255, 255, 255, 0.05);
            color: var(--text-dark);
            font-size: 0.9rem;
        }

        [data-theme="light"] .footer-bottom {
            border-top: 1px solid rgba(0, 0, 0, 0.05);
        }

        /* Animations */
        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes float {
            0% {
                transform: translateY(0px);
            }

            50% {
                transform: translateY(-10px);
            }

            100% {
                transform: translateY(0px);
            }
        }

        /* Responsive Design */
        @media (max-width: 992px) {
            .about-content {
                flex-direction: column;
            }

            .hero h1 {
                font-size: 2.8rem;
            }
        }

       
    </style>
</head>

<body>
    <!-- Header -->
    <!-- Header -->
    <?php include 'header.php'; ?>
    <!-- Hero Section -->
    <section class="hero">
        <div class="container">
            <div class="hero-content">
                <h1>Find Your Dream Job With Work And Workers</h1>
                <p>Connecting talented professionals with top employers worldwide. Discover opportunities that match your skills and aspirations.</p>


                <div>
                    <form class="search-box" action="joblist.php" method="GET">
                        <input type="text" name="keyword" placeholder="Job title, keywords, or company">
                        <input type="text" name="location" placeholder="City, state, or remote">
                        <button type="submit"><i class="fas fa-search"></i> Search Jobs</button>
                    </form>
                </div>


             
        </div>
    </section>

    <!-- About Section -->
    <section class="about">
        <div class="container">
            <div class="section-title">
                <h2>About Work and Workers</h2>
                <p>We are a leading recruitment platform dedicated to connecting job seekers with employers across various industries.</p>
            </div>
            <div class="about-content">
                <div class="about-text">
                    <h3>Your Career Journey Starts Here</h3>
                    <p>Best Employment Services Pvt Ltd is based in Pakistan in the city of Lahore. We are a Best Employment and Management Services company dedicated to providing excellent Employees and services to our clients. We have got legal entity duly approved by Government of Pakistan.</p>
                    <p>With thousands of job listings across multiple sectors, we help professionals at all levels find opportunities that align with their skills, experience, and career goals.</p>
                    <div class="about-stats">
                        <div class="stat">
                            <h4>50K+</h4>
                            <p>Jobs Available</p>
                        </div>
                        <div class="stat">
                            <h4>25K+</h4>
                            <p>Companies</p>
                        </div>
                        <div class="stat">
                            <h4>150K+</h4>
                            <p>Successful Hires</p>
                        </div>
                    </div>
                </div>
                <div class="about-image">
                    <img src="https://images.unsplash.com/photo-1552664730-d307ca884978?ixlib=rb-4.0.3&auto=format&fit=crop&w=1000&q=80" alt="Team collaboration">
                </div>
            </div>
        </div>
    </section>

    <!-- Job Categories -->
    <section class="categories">
        <div class="container">
            <div class="section-title">
                <h2>Vacant Positions</h2>
                <p>Explore opportunities across various industries and find the perfect match for your skills.</p>
            </div>
            <div class="categories-grid">
                <div class="category-card">
                    <div class="category-icon">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h3>Security Guard</h3>
                    <p>Protect people and property with security positions in various settings.</p>
                    <a href="joblist.php?category=security">
                        <button class="btn-apply">Read More <i class="fas fa-arrow-right"></i></button>
                    </a>

                </div>
                <div class="category-card">
                    <div class="category-icon">
                        <i class="fas fa-home"></i>
                    </div>
                    <h3>Housemate</h3>
                    <p>Find live-in positions as caregivers, companions, or property managers.</p>
                    <a href="joblist.php?category=housemate">
                        <button class="btn-apply">Read More<i class="fas fa-arrow-right"></i></button>
                    </a>

                </div>
                <div class="category-card">
                    <div class="category-icon">
                        <i class="fas fa-industry"></i>
                    </div>
                    <h3>Factory Workers</h3>
                    <p>Manufacturing and production roles with competitive wages.</p>
                    <a href="joblist.php?category=factory">
                        <button class="btn-apply">Read More<i class="fas fa-arrow-right"></i></button>
                    </a>

                </div>
                <div class="category-card">
                    <div class="category-icon">
                        <i class="fas fa-calculator"></i>
                    </div>
                    <h3>Accountants</h3>
                    <p>Financial roles from entry-level bookkeepers to CFO positions.</p>
                    <a href="joblist.php?category=accounting">
                        <button class="btn-apply">Read More<i class="fas fa-arrow-right"></i></button>
                    </a>

                </div>
                <div class="category-card">
                    <div class="category-icon">
                        <i class="fas fa-laptop-code"></i>
                    </div>
                    <h3>Developers</h3>
                    <p>Software engineering and web development opportunities.</p>
                    <a href="joblist.php?category=development">
                        <button class="btn-apply">Read More<i class="fas fa-arrow-right"></i></button>
                    </a>

                </div>
                <div class="category-card">
                    <div class="category-icon">
                        <i class="fas fa-network-wired"></i>
                    </div>
                    <h3>IT Jobs</h3>
                    <p>Network administration, cybersecurity, and tech support roles.</p>
                    <a href="joblist.php?category=it">
                        <button class="btn-apply">Read More<i class="fas fa-arrow-right"></i></button>
                    </a>

                </div>
                <div class="category-card">
                    <div class="category-icon">
                        <i class="fas fa-hard-hat"></i>
                    </div>
                    <h3>Labour</h3>
                    <p>Construction, warehouse, and general labor positions.</p>
                    <a href="joblist.php?category=labor">
                        <button class="btn-apply">Read More<i class="fas fa-arrow-right"></i></button>
                    </a>

                </div>
                <div class="category-card">
                    <div class="category-icon">
                        <i class="fas fa-user-tie"></i>
                    </div>
                    <h3>Health Care</h3>
                    <p>Management, consulting, and executive-level opportunities.</p>
                    <a href="joblist.php?category=healthcare">
                        <button class="btn-apply">Read More<i class="fas fa-arrow-right"></i></button>
                    </a>

                </div>
                <div class="category-card">
                    <div class="category-icon">
                        <i class="fas fa-user-tie"></i>
                    </div>
                    <h3>Engineering</h3>
                    <p>Focuses on promoting products or services, attracting customers, and driving business growth.</p>
                    <a href="joblist.php?category=engineering">
                        <button class="btn-apply">Read More<i class="fas fa-arrow-right"></i></button>
                    </a>

                </div>
                <div class="category-card">
                    <div class="category-icon">
                        <i class="fas fa-user-tie"></i>
                    </div>
                    <h3>Education</h3>
                    <p>Management, consulting, and executive-level opportunities.</p>
                    <a href="joblist.php?category=education">
                        <button class="btn-apply">Read More<i class="fas fa-arrow-right"></i></button>
                    </a>

                </div>
                <div class="category-card">
                    <div class="category-icon">
                        <i class="fas fa-user-tie"></i>
                    </div>
                    <h3>Call Center</h3>
                    <p>Involves designing, building, and maintaining machines, structures, and systems using scientific and technical skills..</p>
                    <a href="joblist.php?category=callcenter">
                        <button class="btn-apply">Read More<i class="fas fa-arrow-right"></i></button>
                    </a>

                </div>
                <div class="category-card">
                    <div class="category-icon">
                        <i class="fas fa-user-tie"></i>
                    </div>
                    <h3>E-Commerce</h3>
                    <p>Enters, updates, and maintains accurate information in computer systems or databases.</p>
                    <a href="joblist.php?category=ecommerce">
                        <button class="btn-apply">Read More<i class="fas fa-arrow-right"></i></button>
                    </a>

                </div>
                <div class="category-card">
                    <div class="category-icon">
                        <i class="fas fa-user-tie"></i>
                    </div>
                    <h3>Marketing</h3>
                    <p>Handles customer inquiries, provides support, and resolves issues over phone or online communication.</p>
                    <a href="joblist.php?category=marketing">
                        <button class="btn-apply">Read More<i class="fas fa-arrow-right"></i></button>
                    </a>

                </div>
                <div class="category-card">
                    <div class="category-icon">
                        <i class="fas fa-user-tie"></i>
                    </div>
                    <h3>Dataentry</h3>
                    <p>Provides medical services and support to maintain and improve people's health and well-being.</p>
                    <a href="joblist.php?category=dataentry">
                        <button class="btn-apply">Read More<i class="fas fa-arrow-right"></i></button>
                    </a>

                </div>
            
            </div>

        </div>
    </section>

    <!-- Job Listings Section -->
    <!-- <section class="job-listings">
        <div class="container">
            <div class="section-title">
                <h2>Featured Job Listings</h2>
                <p>Browse through our latest job openings and find your next career opportunity.</p>
            </div>

            <div class="job-filters">
                <button class="filter-btn active">All Jobs</button>
                <button class="filter-btn">Full-time</button>
                <button class="filter-btn">Part-time</button>
                <button class="filter-btn">Remote</button>
                <button class="filter-btn">Contract</button>
            </div>

            <div class="job-cards">
                <div class="job-card">
                    <div class="job-header">
                        <div>
                            <h3 class="job-title">Senior Security Guard</h3>
                            <p class="job-company">SecureCorp International</p>
                        </div>
                        <span class="job-type">Full-time</span>
                    </div>
                    <div class="job-details">
                        <div class="job-detail">
                            <i class="fas fa-map-marker-alt"></i>
                            <span>New York, NY</span>
                        </div>
                        <div class="job-detail">
                            <i class="fas fa-clock"></i>
                            <span>3 days ago</span>
                        </div>
                    </div>
                    <div class="job-footer">
                        <div class="job-salary">$45,000 - $55,000</div>
                        <button class="btn-apply">Read More</button>
                    </div>
                </div>

                <div class="job-card">
                    <div class="job-header">
                        <div>
                            <h3 class="job-title">Live-in Housemate</h3>
                            <p class="job-company">ElderCare Solutions</p>
                        </div>
                        <span class="job-type">Part-time</span>
                    </div>
                    <div class="job-details">
                        <div class="job-detail">
                            <i class="fas fa-map-marker-alt"></i>
                            <span>Los Angeles, CA</span>
                        </div>
                        <div class="job-detail">
                            <i class="fas fa-clock"></i>
                            <span>1 day ago</span>
                        </div>
                    </div>
                    <div class="job-footer">
                        <div class="job-salary">$30,000 - $40,000</div>
                        <button class="btn-apply">Read More</button>
                    </div>
                </div>

                <div class="job-card">
                    <div class="job-header">
                        <div>
                            <h3 class="job-title">Factory Assembly Worker</h3>
                            <p class="job-company">Manufacturing Plus</p>
                        </div>
                        <span class="job-type">Full-time</span>
                    </div>
                    <div class="job-details">
                        <div class="job-detail">
                            <i class="fas fa-map-marker-alt"></i>
                            <span>Chicago, IL</span>
                        </div>
                        <div class="job-detail">
                            <i class="fas fa-clock"></i>
                            <span>5 days ago</span>
                        </div>
                    </div>
                    <div class="job-footer">
                        <div class="job-salary">$35,000 - $42,000</div>
                        <button class="btn-apply">Read More</button>
                    </div>
                </div>

                <div class="job-card">
                    <div class="job-header">
                        <div>
                            <h3 class="job-title">Senior Accountant</h3>
                            <p class="job-company">FinancePro Group</p>
                        </div>
                        <span class="job-type">Full-time</span>
                    </div>
                    <div class="job-details">
                        <div class="job-detail">
                            <i class="fas fa-map-marker-alt"></i>
                            <span>Remote</span>
                        </div>
                        <div class="job-detail">
                            <i class="fas fa-clock"></i>
                            <span>2 days ago</span>
                        </div>
                    </div>
                    <div class="job-footer">
                        <div class="job-salary">$65,000 - $85,000</div>
                        <button class="btn-apply">Read More</button>
                    </div>
                </div>

                <div class="job-card">
                    <div class="job-header">
                        <div>
                            <h3 class="job-title">Full Stack Developer</h3>
                            <p class="job-company">TechInnovate Inc.</p>
                        </div>
                        <span class="job-type">Full-time</span>
                    </div>
                    <div class="job-details">
                        <div class="job-detail">
                            <i class="fas fa-map-marker-alt"></i>
                            <span>San Francisco, CA</span>
                        </div>
                        <div class="job-detail">
                            <i class="fas fa-clock"></i>
                            <span>Just posted</span>
                        </div>
                    </div>
                    <div class="job-footer">
                        <div class="job-salary">$90,000 - $120,000</div>
                        <button class="btn-apply">Read More</button>
                    </div>
                </div>

                <div class="job-card">
                    <div class="job-header">
                        <div>
                            <h3 class="job-title">IT Support Specialist</h3>
                            <p class="job-company">Global Tech Solutions</p>
                        </div>
                        <span class="job-type">Contract</span>
                    </div>
                    <div class="job-details">
                        <div class="job-detail">
                            <i class="fas fa-map-marker-alt"></i>
                            <span>Boston, MA</span>
                        </div>
                        <div class="job-detail">
                            <i class="fas fa-clock"></i>
                            <span>1 week ago</span>
                        </div>
                    </div>
                    <div class="job-footer">
                        <div class="job-salary">$50,000 - $65,000</div>
                        <button class="btn-apply">Read More</button>
                    </div>
                </div>
            </div>
        </div>
    </section> -->

    <!-- CTA Section -->
    <section class="cta">
        <div class="container">
            <h2>Ready to Take the Next Step in Your Career?</h2>
            <p>Join thousands of professionals who have found their dream jobs through Work and Workers. Create your profile today and let employers find you!</p>
            <a href="signin.php" class="btn btn-cta">Create Your Profile Now</a>
        </div>
    </section>

    <!-- Footer -->
    <?php include 'footer.php'; ?>


    <script>
        // Simple animation on scroll
        document.addEventListener('DOMContentLoaded', function() {
            const animatedElements = document.querySelectorAll('.category-card, .about-image, .section-title, .job-card');

            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.style.opacity = '1';
                        entry.target.style.transform = 'translateY(0)';
                    }
                });
            }, {
                threshold: 0.1
            });

            animatedElements.forEach(el => {
                el.style.opacity = '0';
                el.style.transform = 'translateY(20px)';
                el.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
                observer.observe(el);
            });

            // Filter buttons functionality
            const filterButtons = document.querySelectorAll('.filter-btn');
            filterButtons.forEach(button => {
                button.addEventListener('click', () => {
                    filterButtons.forEach(btn => btn.classList.remove('active'));
                    button.classList.add('active');
                });
            });

            // Apply button functionality
            // const applyButtons = document.querySelectorAll('.btn-apply');
            // applyButtons.forEach(button => {
            //     button.addEventListener('click', () => {
            //         const jobTitle = button.closest('.category-card, .job-card').querySelector('h3').textContent;
            //         alert(`Thank you for your interest in the "${jobTitle}" position! Our team will review your application shortly.`);
            //     });
            // });

            // Theme toggle functionality
            const themeToggle = document.getElementById('themeToggle');
            const themeIcon = themeToggle.querySelector('i');

            // Check for saved theme preference or default to dark
            const currentTheme = localStorage.getItem('theme') || 'dark';
            document.documentElement.setAttribute('data-theme', currentTheme);

            // Update icon based on current theme
            if (currentTheme === 'light') {
                themeIcon.classList.remove('fa-moon');
                themeIcon.classList.add('fa-sun');
            } else {
                themeIcon.classList.remove('fa-sun');
                themeIcon.classList.add('fa-moon');
            }

            themeToggle.addEventListener('click', () => {
                const currentTheme = document.documentElement.getAttribute('data-theme');
                const newTheme = currentTheme === 'dark' ? 'light' : 'dark';

                // Update theme
                document.documentElement.setAttribute('data-theme', newTheme);
                localStorage.setItem('theme', newTheme);

                // Update icon
                if (newTheme === 'light') {
                    themeIcon.classList.remove('fa-moon');
                    themeIcon.classList.add('fa-sun');
                } else {
                    themeIcon.classList.remove('fa-sun');
                    themeIcon.classList.add('fa-moon');
                }
            });
        });
    </script>
</body>

</html>