<?php
session_start();

// ================= DB CONNECTION =================
require_once 'connection.php';  // Include the database connection
$conn = Database::connect(); 


// ================= HANDLE DELETE =================
if (isset($_POST['delete_user'])) {
    $delete_id = intval($_POST['id']);
    $stmt = $conn->prepare("DELETE FROM jobs WHERE id = ?");
    $stmt->execute([$delete_id]);
    header("Location: postjob.php?msg=Job deleted successfully");
    exit;
}

// ================= HANDLE UPDATE =================
if (isset($_POST['update'])) {
    $id = intval($_POST['id']);
    $company_name = $_POST['company_name'];
    $job_title = $_POST['job_title'];
    $job_type = $_POST['job_type'];
    $job_category = $_POST['job_category'];
    $salary_range = $_POST['salary_range'];
    $qualifications = $_POST['qualifications'];
    $email = $_POST['email'];

    $stmt = $conn->prepare("
        UPDATE jobs 
        SET company_name = ?, job_title = ?, job_type = ?, job_category = ?, salary_range = ?, qualifications = ?, email = ?
        WHERE id = ?
    ");
    $stmt->execute([$company_name, $job_title, $job_type, $job_category, $salary_range, $qualifications, $email, $id]);
    header("Location: postjob.php?msg=Job updated successfully");
    exit;
}

// ================= HANDLE ALLOW TOGGLE =================
if (isset($_POST['toggle_allow'])) {
    $id = intval($_POST['id']);
    $status = intval($_POST['status']);
    $stmt = $conn->prepare("UPDATE jobs SET allow = ? WHERE id = ?");
    $stmt->execute([$status, $id]);
    exit("success");
}

// ================= FETCH JOBS =================
$filter = $_GET['filter'] ?? '';
if ($filter === 'user' || $filter === 'agent') {
    $stmt = $conn->prepare("SELECT * FROM jobs WHERE filter = ? ORDER BY created_at DESC");
    $stmt->execute([$filter]);
} else {
    $stmt = $conn->query("SELECT * FROM jobs ORDER BY created_at DESC");
}
$jobs = $stmt->fetchAll();
?>






<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>FOODMATE - Post Job</title>

  <!-- Font: Inter -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;800&display=swap" rel="stylesheet">

  <!-- Icons -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">

  <!-- Stylesheet -->
  <link rel="stylesheet" href="./CSS/postjob.css" />
  <link rel="stylesheet" href="./css/customerlist.css">
  
<style>
.modal {
  display: none;
  position: fixed;
  z-index: 999;
  left: 0;
  top: 0;
  width: 100%;
  height: 100%;
  overflow: auto;
  background: rgba(0,0,0,0.5);
}

.modal-content {
  background: #fff;
  margin: 10% auto;
  padding: 25px;
  border-radius: 10px;
  width: 500px;
  max-width: 90%;
  box-shadow: 0 5px 15px rgba(0,0,0,0.3);
}

.modal-content h2 {
  margin-bottom: 15px;
  border-bottom: 2px solid #ddd;
  padding-bottom: 8px;
}

.modal-content input {
  width: 100%;
  margin: 6px 0;
  padding: 8px;
  border: 1px solid #ccc;
  border-radius: 5px;
}

.close {
  float: right;
  font-size: 24px;
  cursor: pointer;
  color: #555;
}

.close:hover {
  color: red;
}



 body { font-family: Arial, sans-serif; background: #f7f8fc; margin: 0; padding: 0px; }
    table {border-collapse: collapse; margin-top: 20px; background: white; border-radius: 8px; overflow: hidden; }
    th, td { padding: 10px; text-align: left; border-bottom: 1px solid #ddd; }
    th { background: #4a90e2; color: white; }
    tr:hover { background: #f1f1f1; }

    .btn { padding: 6px 10px; border: none; border-radius: 5px; color: white; cursor: pointer; }
    .btn-info { background: #17a2b8; }
    .btn-primary { background: #007bff; }
    .btn-danger { background: #dc3545; }

    .switch { position: relative; display: inline-block; width: 40px; height: 20px; }
    .switch input { opacity: 0; width: 0; height: 0; }
    .slider { position: absolute; cursor: pointer; top: 0; left: 0; right: 0; bottom: 0;
              background-color: #ccc; transition: .4s; border-radius: 20px; }
    .slider:before { position: absolute; content: ""; height: 14px; width: 14px;
                     left: 3px; bottom: 3px; background-color: white;
                     transition: .4s; border-radius: 50%; }
    input:checked + .slider { background-color: #4CAF50; }
    input:checked + .slider:before { transform: translateX(20px); }

    /* Modal */
    .modal { display: none; position: fixed; z-index: 100; left: 0; top: 0;
             width: 100%; height: 100%; background-color: rgba(0,0,0,0.5); }
    .modal-content { background: #fff; margin: 10% auto; padding: 20px; border-radius: 8px; width: 50%; }
    .close { float: right; font-size: 24px; cursor: pointer; color: red; }
  </style>
<style>

    .sidebar {
            grid-row: 1 / span 2;
            background: rgb(243, 239, 239);
            border-right: 1px solid rgba(0, 0, 0, 0.06);
            position: relative;
            overflow: hidden;
            backdrop-filter: blur(4px);
        }

        .brand {
            display: flex;
            align-items: center;
            gap: 12px;
            height: 72px;
            padding: 0 16px;
            background: linear-gradient(180deg, rgba(255, 255, 255, 0.10), transparent);
        }

        .brand .logo {
            width: 42px;
            height: 42px;
            border-radius: 14px;
            background: var(--gradient);
            display: grid;
            place-items: center;
            color: white;
            box-shadow: 0 8px 20px rgba(212, 0, 0, .18);
        }

        .brand .title {
            font-weight: 800;
            letter-spacing: 0.6px
        }

        .brand .title span {
            opacity: .85;
            font-weight: 700
        }

        .nav {
            height: calc(100% - 72px);
            overflow-y: auto;
            padding: 12px 0px 24px 0px;
            scrollbar-width: thin
        }

        .nav-group {
            margin: 10px 0
        }

        .nav-item {
            list-style: none;
            margin: 8px 0;
            position: relative;
        }

        .link {
            display: flex;
            align-items: center;
            gap: 14px;
            padding: 12px 14px;
            border-radius: 14px;
            color: var(--text);
            text-decoration: none;
            background: transparent;
            transition: background var(--transition-fast), transform var(--transition-fast), color var(--transition-fast);
            outline: none;
            position: relative;
        }

        .link .icon {
            width: 38px;
            height: 38px;
            border-radius: 12px;
            display: grid;
            place-items: center;
            background: var(--glass);
            box-shadow: inset 0 0 0 1px rgba(0, 0, 0, 0.04);
        }

        .link:hover {
            background: rgba(0, 0, 0, 0.06);
            transform: translateY(-1px)
        }

        .link:active {
            transform: translateY(0)
        }

        .link .chev {
            margin-left: auto;
            transition: transform var(--transition-fast)
        }

        .link.active {
            background: rgba(212, 0, 0, 0.18);
            box-shadow: var(--ring)
        }

        .link.active .icon {
            background: rgba(212, 0, 0, 0.22)
        }

      
        
       

        /* Remove button border for sidebar droconnwns */
        .sidebar .nav-item > button.link {
            border: none;
            background: transparent;
            box-shadow: none;
            width: 100%;
            text-align: left;
            padding: 12px 14px;
        }

        /* Remove focus/active border for droconnwns */
        .sidebar .nav-item > button.link:focus,
        .sidebar .nav-item > button.link:active {
            border: none;
            box-shadow: none;
            outline: none;
        }
       .rotate {
    transform: rotate(180deg);
}

.link.active {
    background: rgba(212, 0, 0, 0.18);
}









.app {
    display: grid;
    grid-template-columns: 280px auto;
    grid-template-rows: 72px auto;
    height: 100vh;
    /* overflow: ; */
}

.sidebar {
    grid-row: 1 / span 2;
    height: 100%;
    overflow-y: auto;
}

.header {
    grid-column: 2;
    height: 70px;
    background: #fff;
    display: flex;
    align-items: center;
    padding: 10px 20px;
    box-shadow: 0 2px 5px rgba(0,0,0,0.05);
}

.main {
    grid-column: 2;
    overflow-y: auto;
    padding: 20px;
    background: #f7f8fc;
    height: calc(100vh - 70px);
}


.job-detail {
  margin: 8px 0;
  line-height: 1.5;
  color: #444;
  font-size: 15px;
}

/* Label (like Company, Title) */
.job-label {
  font-weight: 600;
  color: #222;
  display: inline-block;
  width: 120px; /* fixed width to align all labels */
}

/* Value (like company name, job title) */
.job-value {
  color: #555;
}


</style>

</head>

<body>

<body>
<div class="app">

    <!-- Sidebar -->
   <?php include 'asidebar.php'; ?>

    <!-- Header -->
 <?php include 'header.php';?>

    <!-- Main Content -->

   <main class="main">
   <div class="table-header">
    <h3 style="font-weight:600;">All Jobs</h3>
    <div class="table-actions">
      <div class="table-search">
        <i class="fa-solid fa-magnifying-glass" aria-hidden="true"></i>
        <input type="text" placeholder="Search jobs…" id="tableSearch">
      </div>

      <!-- Filter Button -->
      <!-- <div class="filter-container" style="position: relative; display:inline-block;">
          <button id="filterBtn" class="btn btn-sm btn-secondary">
              <i class="fa-solid fa-filter"></i> Filter
          </button>
          <div id="filterOptions" class="dropdown-menu" style="display:none; position:absolute; top:35px; left:0; background:#fff; border:1px solid #ccc; border-radius:5px; padding:8px; min-width:120px; box-shadow:0 2px 6px rgba(0,0,0,0.1); z-index:100;">
              <a href="?filter=user" class="dropdown-item" style="display:block; padding:5px 10px; color:#333; text-decoration:none;">User</a>
              <a href="?filter=agent" class="dropdown-item" style="display:block; padding:5px 10px; color:#333; text-decoration:none;">Agent</a>
          </div>
      </div> -->

      <!-- <button class="btn btn-sm btn-secondary"><i class="fa-solid fa-download"></i> Export</button> -->
    </div>
  </div>

 <!-- Jobs Table -->
<div style="overflow-x:auto;">
<table>
    <thead>
        <tr>
            <th>Company</th>
            <th>Title</th>
            <th>Type</th>
            <th>Category</th>
            <th>Salary</th>
            <th>Qualification</th>
            <th>Email</th>
            <th>Allow</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php if ($jobs): foreach ($jobs as $job): ?>
        <tr>
            <td><?= htmlspecialchars($job['company_name']); ?></td>
            <td><?= htmlspecialchars($job['job_title']); ?></td>
            <td><?= htmlspecialchars($job['job_type']); ?></td>
            <td><?= htmlspecialchars($job['job_category']); ?></td>
            <td><?= htmlspecialchars($job['salary_range']); ?></td>
            <td><?= htmlspecialchars($job['qualifications']); ?></td>
            <td><?= htmlspecialchars($job['email']); ?></td>
            <td>
                <label class="switch">
                    <input type="checkbox" <?= $job['allow'] ? 'checked' : ''; ?>
                        onchange="toggleAllow(<?= $job['id']; ?>, this.checked)">
                    <span class="slider"></span>
                </label>
            </td>
            <td>
                <!-- View Button -->
                <button class="btn btn-info" onclick='viewJob(<?= json_encode($job); ?>)'>
                    <i class="fa-solid fa-eye"></i>
                </button>
                <!-- Edit Button -->
                <button class="btn btn-primary" onclick='editJob(<?= json_encode($job); ?>)'>
                    <i class="fa-solid fa-pen"></i>
                </button>
                <!-- Delete Form -->
                <form method="POST" style="display:inline;">
                    <input type="hidden" name="id" value="<?= $job['id']; ?>">
                    <button class="btn btn-danger" name="delete_user" onclick="return confirm('Delete this job?')">
                        <i class="fa-solid fa-trash"></i>
                    </button>
                </form>
            </td>
        </tr>
        <?php endforeach; else: ?>
        <tr><td colspan="9" style="text-align:center;">No jobs found.</td></tr>
        <?php endif; ?>
    </tbody>
</table>
</div>

<!-- View Modal -->
<div id="viewModal" class="modal">
    <div class="modal-content">
        <span class="close" onclick="closeModal('viewModal')">&times;</span>
        <div id="viewDetails"></div>
    </div>
</div>

<!-- Edit Modal -->
<div id="editModal" class="modal">
    <div class="modal-content">
        <span class="close" onclick="closeModal('editModal')">&times;</span>
        <form method="POST">
            <input type="hidden" id="edit_id" name="id">
            <label>Company</label><input type="text" id="edit_company" name="company_name" required>
            <label>Job Title</label><input type="text" id="edit_job_title" name="job_title" required>
            <label>Job Type</label><input type="text" id="edit_job_type" name="job_type">
            <label>Category</label><input type="text" id="edit_job_category" name="job_category">
            <label>Salary</label><input type="text" id="edit_salary_range" name="salary_range">
            <label>Qualification</label><input type="text" id="edit_qualification" name="qualifications">
            <label>Email</label><input type="email" id="edit_email" name="email">
            <button type="submit" name="update" class="btn btn-primary">Update</button>
        </form>
    </div>
</div>

  
</main>
</div>




<script>



    // Get input and table elements
    const searchInput = document.getElementById('tableSearch');
    const table = document.querySelector('table tbody');

    searchInput.addEventListener('keyup', function() {
        const filter = searchInput.value.toLowerCase();
        const rows = table.querySelectorAll('tr');

        rows.forEach(row => {
            // Get the email column (7th column, index 6)
            const emailCell = row.cells[6];
            if (emailCell) {
                const emailText = emailCell.textContent.toLowerCase();
                row.style.display = emailText.includes(filter) ? '' : 'none';
            }
        });
    });


function editJob(job) {
  document.getElementById('edit_id').value = job.id;
  document.getElementById('edit_company').value = job.company_name || '';
  document.getElementById('edit_job_title').value = job.job_title || '';
  document.getElementById('edit_job_type').value = job.job_type || '';
  document.getElementById('edit_job_category').value = job.job_category || '';
  document.getElementById('edit_salary_range').value = job.salary_range || '';
  document.getElementById('edit_qualification').value = job.qualifications || '';
  document.getElementById('edit_email').value = job.email || '';
  document.getElementById('editModal').style.display = 'block';
}

function viewJob(job) {
  const html = `
    <p class="job-detail"><span class="job-label">Company:</span> <span class="job-value">${job.company_name}</span></p>
    <p class="job-detail"><span class="job-label">Title:</span> <span class="job-value">${job.job_title}</span></p>
    <p class="job-detail"><span class="job-label">Type:</span> <span class="job-value">${job.job_type}</span></p>
    <p class="job-detail"><span class="job-label">Category:</span> <span class="job-value">${job.job_category}</span></p>
    <p class="job-detail"><span class="job-label">Salary:</span> <span class="job-value">${job.salary_range}</span></p>
    <p class="job-detail"><span class="job-label">Qualification:</span> <span class="job-value">${job.qualifications}</span></p>
    <p class="job-detail"><span class="job-label">Email:</span> <span class="job-value">${job.email}</span></p>
  `;
  document.getElementById('viewDetails').innerHTML = html;
  document.getElementById('viewModal').style.display = 'block';
}
function closeModal(id) {
  document.getElementById(id).style.display = 'none';
}

window.onclick = function(e) {
  document.querySelectorAll('.modal').forEach(m => {
    if (e.target == m) m.style.display = 'none';
  });
};

// ✅ AJAX Allow Toggle
// function toggleAllow(id, checked) {
//   const status = checked ? 1 : 0;
//   fetch('', {
//     method: 'POST',
//     headers: {'Content-Type': 'application/x-www-form-urlencoded'},
//     body: `toggle_allow=1&id=${id}&status=${status}`
//   }).then(res => res.text()).then(txt => {
//     if(res === 'success'){
//       console.log('Allow status updated for user ID', id);
//     }
//   });
// }


 // Toggle dropdown filter
  const filterBtn = document.getElementById('filterBtn');
  const filterOptions = document.getElementById('filterOptions');
  filterBtn.addEventListener('click', () => {
      filterOptions.style.display = filterOptions.style.display === 'none' ? 'block' : 'none';
  });

  // Toggle allow status (optional AJAX)
function toggleAllow(id, checked) {
    const status = checked ? 1 : 0;

    fetch("", {
        method: "POST",
        headers: { "Content-Type": "application/x-www-form-urlencoded" },
        body: `toggle_allow=1&id=${id}&status=${status}`
    })
    .then(res => res.text())
    .then(res => {
        if (res === "success") {
            console.log("Allow updated:", id, status);
        } else {
            alert("Error updating allow status");
        }
    });
}




// function toggleAllow(id, checked){
//   const status = checked ? 1 : 0;
//   fetch('', {
//     method: 'POST',
//     headers: {'Content-Type': 'application/x-www-form-urlencoded'},
//     body: `toggle_allow=1&id=${id}&status=${status}`
//   }).then(res => res.text()).then(res => {
//     if(res === 'success'){
//       console.log('Allow status updated for user ID', id);
//     }
//   });
// }
</script>




</body>

</html>