<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>FOODMATE - General Reports</title>

  <!-- Font: Inter -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;800&display=swap" rel="stylesheet">

  <!-- Icons -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">

  <!-- Stylesheet -->
  <link rel="stylesheet" href="../CSS/generalreports.css" />
</head>

<body>
    <div class="app" id="app">
    <!-- Sidebar -->
    <aside class="sidebar" id="sidebar" aria-label="Sidebar Navigation">
      <!-- Mobile close arrow -->
      <button class="close-mobile" id="closeSidebarMobile" aria-label="Close sidebar" title="Close sidebar">
          <i class="fa-solid fa-arrow-left"></i>
      </button>
      <div class="brand">
        <div class="logo"><i class="fa-solid fa-bowl-food"></i></div>
        <div class="title"><span>FOOD</span>MATE</div>
      </div>
      <nav class="nav" id="nav">
        <ul class="nav-group">
          <!-- 0. Dashboard -->
          <li class="nav-item">
            <a class="link has-tooltip" href="index.php" data-page="Dashboard">
              <span class="icon"><i class="fa-solid fa-house"></i></span>
              <span class="text">Dashboard</span>
              <span class="tooltip">Dashboard</span>
            </a>
          </li>
          <!-- 1. Customer Management (Dropdown) -->
          <li class="nav-item">
            <button class="link has-tooltip" data-toggle="submenu" aria-expanded="false">
              <span class="icon"><i class="fa-solid fa-users"></i></span>
              <span class="text">Customer Management</span>
              <i class="fa-solid fa-chevron-down chev"></i>
              <span class="tooltip">Customer Management</span>
            </button>
            <div class="submenu">
              <!-- <a class="link has-tooltip" href="addcustomer.php" data-page="Add Customer">
                <i class="fa-solid fa-user-plus"></i>
                <span class="text">Add Customer</span>
                <span class="tooltip">Add Customer</span>
              </a> -->
               <a class="link has-tooltip" href="customerlist.php" data-page="Customer List">
                                <i class="fa-solid fa-list"></i>
                                <span class="text">Customer List</span>
                                <!-- <span class="tooltip">Customer List</span> -->
                            </a>
              <a class="link has-tooltip" href="postjob.php" data-page="Customer List">
                <i class="fa-solid fa-list"></i>
                <span class="text">Post Job</span>
                <span class="tooltip">Post Job</span>
              </a>
              <a class="link has-tooltip" href="applyjob.php" data-page="Customer List">
                  <i class="fa-solid fa-list"></i>
                  <span class="text">Apply Job</span>
                  <!-- <span class="tooltip">Customer List</span> -->
                </a>
            </div>
          </li>
          <!-- 2. Customer Renewal -->
          <li class="nav-item">
            <a class="link has-tooltip" href="customerrenewal.php" data-page="Customer Renewal">
              <span class="icon"><i class="fa-solid fa-rotate-right"></i></span>
              <span class="text">Customer Renewal</span>
              <span class="tooltip">Customer Renewal</span>
            </a>
          </li>
          <!-- 3. Renewal List -->
          <li class="nav-item">
            <a class="link has-tooltip" href="renewallist.php" data-page="Renewal List">
              <span class="icon"><i class="fa-solid fa-list-check"></i></span>
              <span class="text">Renewal List</span>
              <span class="tooltip">Renewal List</span>
            </a>
          </li>
          <!-- 4. Reports (Dropdown) -->
          <li class="nav-item">
            <button class="link has-tooltip active" data-toggle="submenu" aria-expanded="false">
              <span class="icon"><i class="fa-solid fa-chart-line"></i></span>
              <span class="text">Reports</span>
              <i class="fa-solid fa-chevron-down chev"></i>
              <span class="tooltip">Reports</span>
            </button>
            <div class="submenu">
              <a class="link has-tooltip" href="recoveryreport.php" data-page="Recovery Report">
                <i class="fa-solid fa-rotate-left"></i>
                <span class="text">Recovery Report</span>
                <span class="tooltip">Recovery Report</span>
              </a>
              <a class="link has-tooltip" href="pendingreport.php" data-page="Pending Report">
                <i class="fa-solid fa-clock"></i>
                <span class="text">Pending Report</span>
                <span class="tooltip">Pending Report</span>
              </a>
              <a class="link has-tooltip active" href="reports.php" data-page="General Reports">
                <i class="fa-solid fa-chart-bar"></i>
                <span class="text">General Reports</span>
                <span class="tooltip">General Reports</span>
              </a>
            </div>
          </li>
        </ul>
      </nav>
    </aside>

    <!-- Header -->
    <header class="header">
      <button class="toggle" id="sidebarToggle" aria-label="Toggle sidebar"><i class="fa-solid fa-bars"></i></button>
      <div class="title-wrap">
        <div class="title" id="pageTitle">General Reports</div>
        <div class="muted" id="headerInfo">Comprehensive business insights and analytics</div>
      </div>

      <div class="pill" id="clock"><i class="fa-regular fa-clock"></i> <span>--:--</span></div>
      <div class="search">
        <i class="fa-solid fa-magnifying-glass" aria-hidden="true"></i>
        <input type="text" placeholder="Search…" aria-label="Search">
        <kbd style="opacity:.6">/</kbd>
      </div>
      <button class="toggle" id="collapseToggle" aria-label="Collapse sidebar"><i
          class="fa-solid fa-grip-lines"></i></button>
      <div style="width:1px;height:28px;background:rgba(255,255,255,0.12);"></div>
      <i class="fa-regular fa-bell" style="font-size:20px;opacity:.9"></i>
      <div class="avatar" title="You" 
           style="width:40px; height:40px; display:flex; align-items:center; justify-content:center; border-radius:50%; background: var(--gradient);">
        <i class="fa-solid fa-user-tie" style="font-size:18px; color:#fcf7f7;"></i>
      </div>
    </header>

    <!-- Main -->
    <main class="main">
      <!-- Page Header -->
      <div class="page-header">
        <div>
          <h2 style="margin-bottom: 8px;">Business Analytics Dashboard</h2>
          <p style="color: var(--muted);">Comprehensive insights into your business performance and customer metrics</p>
        </div>
        <div style="display: flex; gap: 12px;">
          <button class="btn btn-secondary" id="printReport">
            <i class="fa-solid fa-print"></i> Print Report
          </button>
          <button class="btn btn-primary" id="exportReport">
            <i class="fa-solid fa-file-export"></i> Export Report
          </button>
        </div>
      </div>

      <!-- Report Stats Cards -->
      <div class="stats-grid">
        <div class="stat-card">
          <div class="stat-icon primary">
            <i class="fa-solid fa-users"></i>
          </div>
          <div class="stat-content">
            <h3>1,248</h3>
            <p>Total Customers</p>
          </div>
        </div>
        
        <div class="stat-card">
          <div class="stat-icon success">
            <i class="fa-solid fa-chart-line"></i>
          </div>
          <div class="stat-content">
            <h3>PKR 2.4M</h3>
            <p>Total Revenue</p>
          </div>
        </div>
        
        <div class="stat-card">
          <div class="stat-icon warning">
            <i class="fa-solid fa-rotate-right"></i>
          </div>
          <div class="stat-content">
            <h3>87%</h3>
            <p>Renewal Rate</p>
          </div>
        </div>
        
        <div class="stat-card">
          <div class="stat-icon info">
            <i class="fa-solid fa-calendar-check"></i>
          </div>
          <div class="stat-content">
            <h3>1,042</h3>
            <p>Active Subscriptions</p>
          </div>
        </div>
      </div>

      <!-- Performance Charts -->
      <div class="grid">
        <div class="chart-container" style="grid-column: span 8;">
          <div class="chart-header">
            <h3 style="font-weight: 600;">Revenue Trend</h3>
            <div class="chart-actions">
              <select class="filter-select" style="width: 150px;">
                <option>Last 7 Days</option>
                <option>Last 30 Days</option>
                <option selected>Last 90 Days</option>
                <option>This Year</option>
              </select>
            </div>
          </div>
          <div class="chart-placeholder">
            <div style="text-align: center;">
              <i class="fa-solid fa-chart-line" style="font-size: 48px; margin-bottom: 16px; opacity: 0.5;"></i>
              <div>Revenue Trend Chart</div>
              <div style="font-size: 14px; margin-top: 8px;">Visualization of revenue over selected period</div>
            </div>
          </div>
        </div>

        <div class="chart-container" style="grid-column: span 4;">
          <div class="chart-header">
            <h3 style="font-weight: 600;">Customer Distribution</h3>
            <div class="chart-actions">
              <select class="filter-select" style="width: 120px;">
                <option>By Plan</option>
                <option>By Region</option>
                <option>By Industry</option>
              </select>
            </div>
          </div>
          <div class="chart-placeholder">
            <div style="text-align: center;">
              <i class="fa-solid fa-chart-pie" style="font-size: 48px; margin-bottom: 16px; opacity: 0.5;"></i>
              <div>Customer Distribution</div>
              <div style="font-size: 14px; margin-top: 8px;">Breakdown of customers by selected category</div>
            </div>
          </div>
        </div>
      </div>

      <!-- Filter Section -->
      <div class="filter-section">
        <h3 style="margin-bottom: 16px; font-weight: 600;">Report Filters</h3>
        <div class="filter-grid">
          <div class="filter-group">
            <label class="filter-label">Date Range</label>
            <select class="filter-select" id="dateRange">
              <option value="7days">Last 7 Days</option>
              <option value="30days">Last 30 Days</option>
              <option value="90days" selected>Last 90 Days</option>
              <option value="year">This Year</option>
              <option value="custom">Custom Range</option>
            </select>
          </div>
          <div class="filter-group">
            <label class="filter-label">Report Type</label>
            <select class="filter-select" id="reportType">
              <option value="overview">Business Overview</option>
              <option value="revenue">Revenue Analysis</option>
              <option value="customers">Customer Analytics</option>
              <option value="subscriptions">Subscription Metrics</option>
              <option value="performance">Performance Reports</option>
            </select>
          </div>
          <div class="filter-group">
            <label class="filter-label">Customer Segment</label>
            <select class="filter-select" id="customerSegment">
              <option value="all">All Customers</option>
              <option value="enterprise">Enterprise</option>
              <option value="small-business">Small Business</option>
              <option value="startup">Startups</option>
              <option value="individual">Individual</option>
            </select>
          </div>
          <div class="filter-group">
            <button class="btn btn-primary" id="generateReport">
              <i class="fa-solid fa-chart-bar"></i> Generate Report
            </button>
          </div>
        </div>
      </div>

      <!-- Report Table -->
      <div class="table-container">
        <div class="table-header">
          <h3 style="font-weight: 600;">Customer Performance Metrics</h3>
          <div class="table-actions">
            <div class="table-search">
              <i class="fa-solid fa-magnifying-glass" aria-hidden="true"></i>
              <input type="text" placeholder="Search customers…" id="tableSearch">
            </div>
            <button class="btn btn-sm btn-secondary" id="clearFilters">
              <i class="fa-solid fa-rotate-left"></i> Clear Filters
            </button>
          </div>
        </div>
        
        <div style="overflow-x: auto;">
          <table>
            <thead>
              <tr>
                <th>Customer ID</th>
                <th>Customer Name</th>
                <th>Plan</th>
                <th>Join Date</th>
                <th>Renewal Date</th>
                <th>Status</th>
                <th>Revenue</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody id="reportTable">
              <!-- Report data will be populated by JavaScript -->
            </tbody>
          </table>
        </div>
        
        <div class="pagination">
          <div class="pagination-info">Showing 1-10 of 1,248 customers</div>
          <div class="pagination-controls">
            <button class="page-btn"><i class="fa-solid fa-chevron-left"></i></button>
            <button class="page-btn active">1</button>
            <button class="page-btn">2</button>
            <button class="page-btn">3</button>
            <button class="page-btn">4</button>
            <button class="page-btn">5</button>
            <button class="page-btn"><i class="fa-solid fa-chevron-right"></i></button>
          </div>
        </div>
      </div>

      <!-- Report Insights -->
      <div class="grid">
        <section class="card" style="grid-column: span 6;">
          <h3 style="margin-bottom: 16px; font-weight: 600;">Revenue by Customer Segment</h3>
          <div class="report-categories">
            <div class="category-item">
              <span>Enterprise Customers</span>
              <span style="font-weight: 600; color: var(--primary);">PKR 1.2M</span>
            </div>
            <div class="category-item">
              <span>Small Business</span>
              <span style="font-weight: 600; color: var(--primary);">PKR 650K</span>
            </div>
            <div class="category-item">
              <span>Startups</span>
              <span style="font-weight: 600; color: var(--primary);">PKR 320K</span>
            </div>
            <div class="category-item">
              <span>Individual Plans</span>
              <span style="font-weight: 600; color: var(--primary);">PKR 230K</span>
            </div>
          </div>
        </section>

        <section class="card" style="grid-column: span 6;">
          <h3 style="margin-bottom: 16px; font-weight: 600;">Subscription Metrics</h3>
          <div class="report-stats">
            <div class="report-stat-card">
              <h4>Active Plans</h4>
              <div class="value total-customers">1,042</div>
              <div style="font-size: 12px; color: var(--muted);">83.5% of total</div>
            </div>
            <div class="report-stat-card">
              <h4>Renewal Rate</h4>
              <div class="value renewal-rate">87%</div>
              <div style="font-size: 12px; color: var(--muted);">+5% from last quarter</div>
            </div>
            <div class="report-stat-card">
              <h4>Avg. Revenue</h4>
              <div class="value revenue">PKR 1,923</div>
              <div style="font-size: 12px; color: var(--muted);">Per customer</div>
            </div>
          </div>
        </section>
      </div>
      
      <div style="text-align: center; margin-top: 30px;" class="footer">© <span id="year"></span> FOODMATE Created by <span title="love"
                    style="color:var(--secondary); ">IT Genesis</span></div>
    </main>
  </div>
  
  <script src="../JS/generalreports.js"></script>
</body>

</html>