<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>FOODMATE - Customer Renewal</title>

  <!-- Font: Inter -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;800&display=swap" rel="stylesheet">

  <!-- Icons -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">

  <!-- Stylesheet -->
  <link rel="stylesheet" href="../CSS/customerrenewal.css" />
</head>

<body>
        <div class="app" id="app">
        <!-- Sidebar -->
        <aside class="sidebar" id="sidebar" aria-label="Sidebar Navigation">
            <!-- Mobile close arrow -->
            <button class="close-mobile" id="closeSidebarMobile" aria-label="Close sidebar" title="Close sidebar">
                <i class="fa-solid fa-arrow-left"></i>
            </button>
            <div class="brand">
                <div class="logo"><i class="fa-solid fa-users"></i></div>
                <div class="title"><span>CUSTOMER</span> Management</div>
            </div>
            <nav class="nav" id="nav">
                <ul class="nav-group">
          <!-- 0. Dashboard -->
          <li class="nav-item">
            <a class="link has-tooltip" href="index.php" data-page="Dashboard">
              <span class="icon"><i class="fa-solid fa-house"></i></span>
              <span class="text">Dashboard</span>
              <span class="tooltip">Dashboard</span>
            </a>
          </li>
          <!-- 1. Customer Management (Dropdown) -->
          <li class="nav-item">
            <button class="link has-tooltip" data-toggle="submenu" aria-expanded="false">
              <span class="icon"><i class="fa-solid fa-users"></i></span>
              <span class="text">Customer Management</span>
              <i class="fa-solid fa-chevron-down chev"></i>
              <span class="tooltip">Customer Management</span>
            </button>
            <div class="submenu">
              <!-- <a class="link has-tooltip" href="addcustomer.php" data-page="Add Customer">
                <i class="fa-solid fa-user-plus"></i>
                <span class="text">Add Customer</span>
                <span class="tooltip">Add Customer</span>
              </a> -->
               <a class="link has-tooltip" href="customerlist.php" data-page="Customer List">
                                <i class="fa-solid fa-list"></i>
                                <span class="text">Customer List</span>
                                <!-- <span class="tooltip">Customer List</span> -->
                            </a>
              <a class="link has-tooltip" href="postjob.php" data-page="Customer List">
                <i class="fa-solid fa-list"></i>
                <span class="text">Post Job</span>
                <span class="tooltip">Post Job</span>
              </a>
              <a class="link has-tooltip" href="applyjob.php" data-page="Customer List">
                  <i class="fa-solid fa-list"></i>
                  <span class="text">Apply Job</span>
                  <!-- <span class="tooltip">Customer List</span> -->
                </a>
            </div>
          </li>
          <!-- 2. Customer Renewal -->
          <li class="nav-item">
            <a class="link has-tooltip active" href="customerrenewal.php" data-page="Customer Renewal">
              <span class="icon"><i class="fa-solid fa-rotate-right"></i></span>
              <span class="text">Customer Renewal</span>
              <span class="tooltip">Customer Renewal</span>
            </a>
          </li>
          <!-- 3. Renewal List -->
          <li class="nav-item">
            <a class="link has-tooltip" href="renewallist.php" data-page="Renewal List">
              <span class="icon"><i class="fa-solid fa-list-check"></i></span>
              <span class="text">Renewal List</span>
              <span class="tooltip">Renewal List</span>
            </a>
          </li>
          <!-- 4. Reports (Dropdown) -->
          <li class="nav-item">
            <button class="link has-tooltip" data-toggle="submenu" aria-expanded="false">
              <span class="icon"><i class="fa-solid fa-chart-line"></i></span>
              <span class="text">Reports</span>
              <i class="fa-solid fa-chevron-down chev"></i>
              <span class="tooltip">Reports</span>
            </button>
            <div class="submenu">
              <a class="link has-tooltip" href="recoveryreport.php" data-page="Recovery Report">
                <i class="fa-solid fa-rotate-left"></i>
                <span class="text">Recovery Report</span>
                <span class="tooltip">Recovery Report</span>
              </a>
              <a class="link has-tooltip" href="pendingreport.php" data-page="Pending Report">
                <i class="fa-solid fa-clock"></i>
                <span class="text">Pending Report</span>
                <span class="tooltip">Pending Report</span>
              </a>
              <a class="link has-tooltip" href="reports.php" data-page="General Reports">
                <i class="fa-solid fa-chart-bar"></i>
                <span class="text">General Reports</span>
                <span class="tooltip">General Reports</span>
              </a>
            </div>
          </li>
        </ul>
      </nav>
    </aside>

    <!-- Header -->
    <header class="header">
      <button class="toggle" id="sidebarToggle" aria-label="Toggle sidebar"><i class="fa-solid fa-bars"></i></button>
      <div class="title-wrap">
        <div class="title" id="pageTitle">Customer Renewal</div>
        <div class="muted" id="headerInfo">Manage customer subscription renewals</div>
      </div>

      <div class="pill" id="clock"><i class="fa-regular fa-clock"></i> <span>--:--</span></div>
      <div class="search">
        <i class="fa-solid fa-magnifying-glass" aria-hidden="true"></i>
        <input type="text" placeholder="Search…" aria-label="Search">
        <kbd style="opacity:.6">/</kbd>
      </div>
      <button class="toggle" id="collapseToggle" aria-label="Collapse sidebar"><i
          class="fa-solid fa-grip-lines"></i></button>
      <div style="width:1px;height:28px;background:rgba(255,255,255,0.12);"></div>
      <i class="fa-regular fa-bell" style="font-size:20px;opacity:.9"></i>
      <div class="avatar" title="You" 
           style="width:40px; height:40px; display:flex; align-items:center; justify-content:center; border-radius:50%; background: var(--gradient);">
        <i class="fa-solid fa-user-tie" style="font-size:18px; color:#fcf7f7;"></i>
      </div>
    </header>

    <!-- Main -->
    <main class="main">
      <!-- Page Header -->
      <div class="page-header">
        <div>
          <h2 style="margin-bottom: 8px;">Customer Renewal Management</h2>
          <p style="color: var(--muted);">Manage and process customer subscription renewals</p>
        </div>
        <button class="btn btn-primary" id="bulkRenewBtn">
          <i class="fa-solid fa-rotate"></i> Bulk Renew Selected
        </button>
      </div>

      <!-- Renewal Stats Cards -->
      <div class="stats-grid">
        <div class="stat-card">
          <div class="stat-icon primary">
            <i class="fa-solid fa-clock"></i>
          </div>
          <div class="stat-content">
            <h3>142</h3>
            <p>Pending Renewals</p>
          </div>
        </div>
        
        <div class="stat-card">
          <div class="stat-icon warning">
            <i class="fa-solid fa-exclamation-triangle"></i>
          </div>
          <div class="stat-content">
            <h3>28</h3>
            <p>Expired Subscriptions</p>
          </div>
        </div>
        
        <div class="stat-card">
          <div class="stat-icon success">
            <i class="fa-solid fa-check-circle"></i>
          </div>
          <div class="stat-content">
            <h3>89</h3>
            <p>Renewed This Month</p>
          </div>
        </div>
        
        <div class="stat-card">
          <div class="stat-icon info">
            <i class="fa-solid fa-calendar-day"></i>
          </div>
          <div class="stat-content">
            <h3>64</h3>
            <p>Upcoming Renewals</p>
          </div>
        </div>
      </div>

      <!-- Renewal Table -->
      <div class="table-container">
        <div class="table-header">
          <h3 style="font-weight: 600;">Pending Renewals</h3>
          <div class="table-actions">
            <div class="table-search">
              <i class="fa-solid fa-magnifying-glass" aria-hidden="true"></i>
              <input type="text" placeholder="Search renewals…" id="tableSearch">
            </div>
            <button class="btn btn-sm btn-secondary">
              <i class="fa-solid fa-filter"></i> Filter
            </button>
            <button class="btn btn-sm btn-secondary">
              <i class="fa-solid fa-download"></i> Export
            </button>
          </div>
        </div>
        
        <div style="overflow-x: auto;">
          <table>
            <thead>
              <tr>
                <th style="width: 40px;">
                  <input type="checkbox" id="selectAll">
                </th>
                <th>Customer</th>
                <th>Current Plan</th>
                <th>Renewal Date</th>
                <th>Days Left</th>
                <th>Amount</th>
                <th>Status</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody id="renewalsTable">
              <!-- Renewals will be populated by JavaScript -->
            </tbody>
          </table>
        </div>
        
        <div class="pagination">
          <div class="pagination-info">Showing 1-10 of 142 pending renewals</div>
          <div class="pagination-controls">
            <button class="page-btn"><i class="fa-solid fa-chevron-left"></i></button>
            <button class="page-btn active">1</button>
            <button class="page-btn">2</button>
            <button class="page-btn">3</button>
            <button class="page-btn">4</button>
            <button class="page-btn">5</button>
            <button class="page-btn"><i class="fa-solid fa-chevron-right"></i></button>
          </div>
        </div>
      </div>
      
      <div style="text-align: center; margin-top: 30px;" class="footer">© <span id="year"></span> FOODMATE Created by <span title="love"
                    style="color:var(--secondary); ">IT Genesis</span></div>
    </main>
  </div>
  
  <script src="../JS/customerrenewal.js"></script>
</body>

</html>