<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>FOODMATE - Customer Removal</title>

  <!-- Font: Inter -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;800&display=swap" rel="stylesheet">

  <!-- Icons -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">

  <!-- Stylesheet -->
  <link rel="stylesheet" href="../CSS/customerremoval.css" />
</head>

<body>
    <div class="app" id="app">
    <!-- Sidebar -->
    <aside class="sidebar" id="sidebar" aria-label="Sidebar Navigation">
      <div class="brand">
        <div class="logo"><i class="fa-solid fa-bowl-food"></i></div>
        <div class="title"><span>FOOD</span>MATE</div>
      </div>
      <nav class="nav" id="nav">
        <ul class="nav-group">
          <!-- 0. Dashboard -->
          <li class="nav-item">
            <a class="link has-tooltip" href="index.php" data-page="Dashboard">
              <span class="icon"><i class="fa-solid fa-house"></i></span>
              <span class="text">Dashboard</span>
            </a>
          </li>
          <!-- 1. Customer Management (Dropdown) -->
          <li class="nav-item">
            <button class="link has-tooltip" data-toggle="submenu" aria-expanded="false">
              <span class="icon"><i class="fa-solid fa-users"></i></span>
              <span class="text" style="font-size: 16px;">Customer Management</span>
              <i class="fa-solid fa-chevron-down chev"></i>
            </button>
            <div class="submenu">
              <!-- <a href="addcustomer.php" data-page="Add Customer"><i class="fa-solid fa-user-plus"></i> Add Customer</a> -->
               <a class="link has-tooltip" href="customerlist.php" data-page="Customer List">
                                <i class="fa-solid fa-list"></i>
                                <span class="text">Customer List</span>
                                <!-- <span class="tooltip">Customer List</span> -->
                            </a>
              <a class="link has-tooltip" href="postjob.php" data-page="Customer List">
                <i class="fa-solid fa-list"></i>Post Job</a>
                <a class="link has-tooltip" href="applyjob.php" data-page="Customer List">
                  <i class="fa-solid fa-list"></i>
                  <span class="text">Apply Job</span>
                  <!-- <span class="tooltip">Customer List</span> -->
                </a>
            </div>
          </li>
          <!-- 2. Customer Removal (Dropdown) -->
          <li class="nav-item">
            <button class="link has-tooltip active" data-toggle="submenu" aria-expanded="false">
              <span class="icon"><i class="fa-solid fa-user-minus"></i></span>
              <span class="text" style="font-size: 16px;">Customer Removal</span>
              <i class="fa-solid fa-chevron-down chev"></i>
            </button>
            <div class="submenu" style="height: 88px;">
              <a href="customerremoval.php" data-page="Customer Removal" class="active"><i class="fa-solid fa-user-xmark"></i>Customer Removal</a>
              <a class="link has-tooltip" href="removallist.php" data-page="Removal List"><i class="fa-solid fa-list-check"></i>Removal List</a>
            </div>
          </li>
          <!-- 3. Customer Segments -->
          <li class="nav-item">
            <a class="link has-tooltip" href="customersegments.php" data-page="Customer Segments">
              <span class="icon"><i class="fa-solid fa-object-group"></i></span>
              <span class="text">Customer Segments</span>
            </a>
          </li>
          <!-- 4. Loyalty Program -->
          <li class="nav-item">
            <a class="link has-tooltip" href="loyalty.php" data-page="Loyalty Program">
              <span class="icon"><i class="fa-solid fa-award"></i></span>
              <span class="text">Loyalty Program</span>
            </a>
          </li>
          <!-- 5. Communication -->
          <li class="nav-item">
            <a class="link has-tooltip" href="communication.php" data-page="Communication">
              <span class="icon"><i class="fa-solid fa-comment-dots"></i></span>
              <span class="text">Communication</span>
            </a>
          </li>
          <!-- 6. Feedback & Reviews -->
          <li class="nav-item">
            <a class="link has-tooltip" href="feedback.php" data-page="Feedback & Reviews">
              <span class="icon"><i class="fa-solid fa-star"></i></span>
              <span class="text">Feedback & Reviews</span>
            </a>
          </li>
          <!-- 7. Reports (Dropdown) -->
          <li class="nav-item">
            <button class="link has-tooltip" data-toggle="submenu" aria-expanded="false">
              <span class="icon"><i class="fa-solid fa-chart-line"></i></span>
              <span class="text" style="font-size: 16px;">Reports</span>
              <i class="fa-solid fa-chevron-down chev"></i>
            </button>
            <div class="submenu">
              <a href="recoveryreport.php" data-page="Recovery Report"><i class="fa-solid fa-rotate-left"></i>Recovery Report</a>
              <a class="link has-tooltip" href="pendingreport.php" data-page="Pending Report"><i class="fa-solid fa-clock"></i>Pending Report</a>
              <a class="link has-tooltip" href="reports.php" data-page="General Reports"><i class="fa-solid fa-chart-bar"></i>General Reports</a>
            </div>
          </li>
        </ul>
      </nav>
    </aside>

    <!-- Header -->
    <header class="header">
      <button class="toggle" id="sidebarToggle" aria-label="Toggle sidebar"><i class="fa-solid fa-bars"></i></button>
      <div class="title-wrap">
        <div class="title" id="pageTitle">Customer Removal</div>
        <div class="muted" id="headerInfo">Remove customer accounts and manage removal process</div>
      </div>

      <div class="pill" id="clock"><i class="fa-regular fa-clock"></i> <span>--:--</span></div>
      <div class="search">
        <i class="fa-solid fa-magnifying-glass" aria-hidden="true"></i>
        <input type="text" placeholder="Search…" aria-label="Search">
        <kbd style="opacity:.6">/</kbd>
      </div>
      <button class="toggle" id="collapseToggle" aria-label="Collapse sidebar"><i
          class="fa-solid fa-grip-lines"></i></button>
      <div style="width:1px;height:28px;background:rgba(255,255,255,0.12);"></div>
      <i class="fa-regular fa-bell" style="font-size:20px;opacity:.9"></i>
      <div class="avatar" title="You" 
           style="width:40px; height:40px; display:flex; align-items:center; justify-content:center; border-radius:50%; background: var(--gradient);">
        <i class="fa-solid fa-user-tie" style="font-size:18px; color:#fcf7f7;"></i>
      </div>
    </header>

    <!-- Main -->
    <main class="main">
      <!-- Page Header -->
      <div class="page-header">
        <div>
          <h2 style="margin-bottom: 8px;">Customer Removal Process</h2>
          <p style="color: var(--muted);">Remove customer accounts and manage the removal workflow</p>
        </div>
        <button class="btn btn-secondary" onclick="window.location.href='removallist.php'">
          <i class="fa-solid fa-list-check"></i> View Removal List
        </button>
      </div>

      <!-- Stats Cards -->
      <div class="stats-grid">
        <div class="stat-card">
          <div class="stat-icon danger">
            <i class="fa-solid fa-user-xmark"></i>
          </div>
          <div class="stat-content">
            <h3>48</h3>
            <p>Pending Removals</p>
          </div>
        </div>
        
        <div class="stat-card">
          <div class="stat-icon warning">
            <i class="fa-solid fa-clock-rotate-left"></i>
          </div>
          <div class="stat-content">
            <h3>12</h3>
            <p>Under Review</p>
          </div>
        </div>
        
        <div class="stat-card">
          <div class="stat-icon success">
            <i class="fa-solid fa-rotate-left"></i>
          </div>
          <div class="stat-content">
            <h3>24</h3>
            <p>Recovered Accounts</p>
          </div>
        </div>
        
        <div class="stat-card">
          <div class="stat-icon info">
            <i class="fa-solid fa-trash"></i>
          </div>
          <div class="stat-content">
            <h3>156</h3>
            <p>Total Removed</p>
          </div>
        </div>
      </div>

      <!-- Warning Alert -->
      <div class="warning-alert">
        <i class="fa-solid fa-triangle-exclamation"></i>
        <div>
          <strong>Warning:</strong> Customer removal is a permanent action. Please ensure you have proper authorization and have backed up any important data before proceeding.
        </div>
      </div>

      <!-- Form Container -->
      <div class="form-container">
        <!-- Customer Selection Card -->
        <div class="form-card">
          <div class="form-header">
            <h3><i class="fa-solid fa-magnifying-glass"></i> Select Customer</h3>
          </div>
          
          <div class="customer-search">
            <label class="form-label" for="customerSearch">Search Customer</label>
            <input type="text" id="customerSearch" class="form-control" placeholder="Search by name, email, or phone...">
            <div class="search-results" id="searchResults">
              <!-- Search results will appear here -->
            </div>
          </div>
          
          <div class="selected-customer" id="selectedCustomer">
            <div class="customer-info">
              <div class="customer-avatar" id="customerAvatar">AR</div>
              <div class="customer-details">
                <h4 id="customerName">Ahmed Raza</h4>
                <p id="customerEmail">ahmed@techsolutions.com</p>
                <p id="customerPhone">+92 300 1234567</p>
                <p id="customerCompany">Tech Solutions Ltd</p>
                <p><strong>Services:</strong> <span id="customerServices">Website, Domain</span></p>
                <p><strong>Join Date:</strong> <span id="customerJoinDate">Jan 15, 2024</span></p>
              </div>
            </div>
          </div>
        </div>
        
        <!-- Removal Details Card -->
        <div class="form-card">
          <div class="form-header">
            <h3><i class="fa-solid fa-clipboard-list"></i> Removal Details</h3>
          </div>
          
          <div class="form-group">
            <label class="form-label">Removal Reason *</label>
            <div class="removal-reasons">
              <label class="reason-option" for="reasonInactive">
                <div class="reason-icon">
                  <i class="fa-solid fa-user-clock"></i>
                </div>
                <div>
                  <div style="font-weight: 600;">Inactive Account</div>
                  <div style="font-size: 12px; color: var(--muted);">Customer hasn't used services</div>
                </div>
                <input type="radio" id="reasonInactive" name="removalReason" value="inactive">
              </label>
              
              <label class="reason-option" for="reasonRequested">
                <div class="reason-icon">
                  <i class="fa-solid fa-user-minus"></i>
                </div>
                <div>
                  <div style="font-weight: 600;">Customer Requested</div>
                  <div style="font-size: 12px; color: var(--muted);">Customer asked for removal</div>
                </div>
                <input type="radio" id="reasonRequested" name="removalReason" value="requested">
              </label>
              
              <label class="reason-option" for="reasonPayment">
                <div class="reason-icon">
                  <i class="fa-solid fa-credit-card"></i>
                </div>
                <div>
                  <div style="font-weight: 600;">Payment Issues</div>
                  <div style="font-size: 12px; color: var(--muted);">Outstanding payments</div>
                </div>
                <input type="radio" id="reasonPayment" name="removalReason" value="payment">
              </label>
              
              <label class="reason-option" for="reasonPolicy">
                <div class="reason-icon">
                  <i class="fa-solid fa-ban"></i>
                </div>
                <div>
                  <div style="font-weight: 600;">Policy Violation</div>
                  <div style="font-size: 12px; color: var(--muted);">Terms of service violation</div>
                </div>
                <input type="radio" id="reasonPolicy" name="removalReason" value="policy">
              </label>
            </div>
          </div>
          
          <div class="form-group">
            <label class="form-label" for="removalDetails">Additional Details</label>
            <textarea id="removalDetails" class="form-control" placeholder="Provide additional information about the removal reason..."></textarea>
          </div>
          
          <div class="form-group">
            <label class="form-label" for="removalDate">Removal Date *</label>
            <input type="date" id="removalDate" class="form-control" required>
          </div>
          
          <div class="form-group">
            <label class="form-label">Data Handling</label>
            <div style="display: flex; flex-direction: column; gap: 12px;">
              <label style="display: flex; align-items: center; gap: 8px;">
                <input type="checkbox" id="backupData" checked>
                <span>Create data backup before removal</span>
              </label>
              <label style="display: flex; align-items: center; gap: 8px;">
                <input type="checkbox" id="notifyCustomer">
                <span>Notify customer about removal</span>
              </label>
              <label style="display: flex; align-items: center; gap: 8px;">
                <input type="checkbox" id="retainRecords">
                <span>Retain customer records for 30 days</span>
              </label>
            </div>
          </div>
        </div>
        
        <!-- Removal Summary Card -->
        <div class="form-card">
          <div class="form-header">
            <h3><i class="fa-solid fa-triangle-exclamation"></i> Removal Summary</h3>
          </div>
          
          <div class="removal-summary">
            <div class="summary-item">
              <span>Customer:</span>
              <span id="summaryCustomer">Not selected</span>
            </div>
            <div class="summary-item">
              <span>Removal Reason:</span>
              <span id="summaryReason">Not selected</span>
            </div>
            <div class="summary-item">
              <span>Removal Date:</span>
              <span id="summaryDate">Not set</span>
            </div>
            <div class="summary-item">
              <span>Data Backup:</span>
              <span id="summaryBackup">Enabled</span>
            </div>
            <div class="summary-item">
              <span>Status:</span>
              <span style="color: var(--danger); font-weight: 600;" id="summaryStatus">Pending Removal</span>
            </div>
          </div>
          
          <div class="form-hint" style="text-align: center; margin-top: 16px;">
            <i class="fa-solid fa-info-circle"></i> Review all information carefully before proceeding with customer removal.
          </div>
        </div>
        
        <!-- Form Actions -->
        <div class="form-footer">
          <button class="btn btn-secondary" onclick="window.location.href='postjob.php'">Cancel</button>
          <button class="btn btn-warning" id="reviewRemovalBtn">
            <i class="fa-solid fa-clock"></i> Mark for Review
          </button>
          <button class="btn btn-danger" id="confirmRemovalBtn">
            <i class="fa-solid fa-user-xmark"></i> Confirm Removal
          </button>
        </div>
      </div>
      
      <div style="text-align: center; margin-top: 30px;" class="footer">© <span id="year"></span> FOODMATE Created by <span title="love"
                    style="color:var(--secondary); ">IT Genesis</span></div>
    </main>
  </div>
  
  <script src="../JS/customerremoval.js"></script>
</body>

</html>