<style>
   /* Sidebar */
   /* ------------------------------
   Professional Sidebar Theme
--------------------------------*/



/* --------------------------------------
   PROFESSIONAL MODERN SIDEBAR THEME
---------------------------------------*/
:root {
    --primary: #0052CC;
    --primary-dark: #003A91;
    --primary-light: #4C9AFF;
    --accent: #1EB5FF;

    --bg: #F4F7FB;
    --text: #1E2A39;

    --glass: rgba(255, 255, 255, 0.55);
    --gradient: linear-gradient(135deg, #0052CC, #4C9AFF);

    --ring: 0 0 0 2px rgba(0, 82, 204, 0.25);
    --transition-fast: 0.18s ease;
    --transition-slow: 0.35s ease;
}

/* Sidebar */
.sidebar {
    background: var(--bg);
    border-right: 1px solid rgba(0,0,0,0.06);
    height: 100%;
    backdrop-filter: blur(7px);
    box-shadow: 3px 0 10px rgba(0,0,0,0.04);
}

/* Brand top bar */
.brand {
    display: flex;
    align-items: center;
    gap: 14px;
    height: 85px;
    padding: 0 18px;
    background: linear-gradient(180deg, rgba(255,255,255,0.5), transparent);
    border-bottom: 1px solid rgba(0,0,0,0.06);
}

.brand .logo {
    width: 48px;
    height: 48px;
    border-radius: 14px;
    background: var(--gradient);
    display: grid;
    place-items: center;
    font-size: 20px;
    color: #fff;
    box-shadow: 0 8px 20px rgba(0,82,204,0.25);
}

.brand .title {
    font-weight: 800;
    letter-spacing: .4px;
    font-size: 18px;
}

/* Navigation */
.nav {
    padding: 14px 0 24px;
}

/* Nav items */
.link {
    display: flex;
    align-items: center;
    gap: 14px;
    padding: 12px 16px;
    border-radius: 14px;
    color: var(--text);
    text-decoration: none;
    transition: var(--transition-fast);
    cursor: pointer;
}

/* ICON STYLE */
.link .icon {
    width: 42px;
    height: 42px;
    border-radius: 12px;
    background: var(--glass);
    box-shadow: inset 0 0 0 1px rgba(0,0,0,0.06);
    display: grid;
    place-items: center;
    font-size: 18px;
    color: var(--primary-dark);
}

/* Hover */
.link:hover {
    background: rgba(0,82,204,0.10);
    transform: translateY(-2px);
}

/* Active */
.link.active {
    background: rgba(0,82,204,0.20);
    box-shadow: var(--ring);
}

.link.active .icon {
    background: var(--primary-light);
    color: #fff;
}

/* Dropdown arrow */
.chev {
    margin-left: auto;
    transition: transform 0.25s ease;
    font-size: 14px;
}

.rotate {
    transform: rotate(180deg);
}

/* Submenu */
.submenu {
    height: 0;
    overflow: hidden;
    padding-left: 34px;
    transition: height var(--transition-slow);
    display: flex;
    flex-direction: column;
    gap: 3%;
}

.submenu a {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 9px 12px;
    border-radius: 12px;
    font-size: 15px;
    color: var(--text);
    background: transparent;
}

.submenu a:hover {
    background: rgba(0, 82, 204, 0.08);
}

.submenu a.active {
    background: rgba(0, 82, 204, 0.15);
    font-weight: 600;
}

/* Button dropdown fix */
.sidebar .nav-item > button.link {
    border: none;
    background: transparent;
    text-align: left;
    width: 100%;
}

.sidebar button:focus {
    outline: none;
    box-shadow: none;
}
/* ===== REMOVE UNDERLINE + HIDE SCROLLBAR ===== */

/* Remove underline */
.sidebar a {
    text-decoration: none !important;
}

/* Hide scrollbar */
.sidebar::-webkit-scrollbar {
    display: none;
}

.sidebar {
    -ms-overflow-style: none;   /* IE / Edge */
    scrollbar-width: none;      /* Firefox */
}


</style>

<!-- Sidebar -->
        <aside class="sidebar" id="sidebar" aria-label="Sidebar Navigation">
            <!-- Mobile close arrow// -->
            <button class="close-mobile" id="closeSidebarMobile" aria-label="Close sidebar" title="Close sidebar">
                <i class="fa-solid fa-arrow-left"></i>
            </button>
            <div class="brand">
                <div class="logo"><i class="fa-solid fa-users"></i></div>
                <div class="title"><span>CUSTOMER</span> Management</div>
            </div>
            <nav class="nav" id="nav">
                <ul class="nav-group">
          <!-- 0. Dashboard -->
     <li class="nav-item">
    <a class="link" href="index.php">
        <span class="icon"><i class="fa-solid fa-gauge-high"></i></span>
        <span class="text">Dashboard</span>
    </a>
</li>

<li class="nav-item">
    <button class="link" data-toggle="submenu">
        <span class="icon"><i class="fa-solid fa-users-gear"></i></span>
        <span class="text">Customer Management</span>
        <i class="fa-solid fa-chevron-down chev"></i>
    </button>

    <div class="submenu">
        <a href="customerlist.php"><i class="fa-solid fa-user-group"></i> Customer List</a>
        <a href="postjob.php"><i class="fa-solid fa-briefcase"></i> Post Job</a>
        <a href="applyjob.php"><i class="fa-solid fa-file-signature"></i> Apply Job</a>
    </div>
</li>


      </nav>
    </aside>
     


   <script>
document.addEventListener("DOMContentLoaded", () => {

    const dropdownButtons = document.querySelectorAll("[data-toggle='submenu']");
    const allSubmenus = document.querySelectorAll(".submenu");

    // Dropdown toggle
    dropdownButtons.forEach(button => {
        button.addEventListener("click", () => {
            const submenu = button.nextElementSibling;
            const arrow = button.querySelector(".chev");

            // Close all others
            allSubmenus.forEach(sm => {
                if (sm !== submenu) {
                    sm.style.height = "0px";
                    sm.previousElementSibling.querySelector(".chev")?.classList.remove("rotate");
                }
            });

            // Toggle current
            if (submenu.style.height !== "0px" && submenu.style.height !== "") {
                submenu.style.height = "0px";
                arrow.classList.remove("rotate");
            } else {
                submenu.style.height = submenu.scrollHeight + "px";
                arrow.classList.add("rotate");
            }
        });
    });

    // Keep submenu open for active page
    const currentPage = location.pathname.split("/").pop();

    document.querySelectorAll(".submenu a").forEach(link => {
        if (link.getAttribute("href") === currentPage) {
            link.classList.add("active");
            const submenu = link.closest(".submenu");
            submenu.style.height = submenu.scrollHeight + "px";
            submenu.previousElementSibling.querySelector(".chev").classList.add("rotate");
        }
    });
});

</script>

