<style>
   /* Sidebar */
        .sidebar {
            grid-row: 1 / span 2;
            background: rgb(243, 239, 239);
            border-right: 1px solid rgba(0, 0, 0, 0.06);
            position: relative;
            overflow: hidden;
            backdrop-filter: blur(4px);
        }

        .brand {
            display: flex;
            align-items: center;
            gap: 12px;
            height: 72px;
            padding: 0 16px;
            background: linear-gradient(180deg, rgba(255, 255, 255, 0.10), transparent);
        }

        .brand .logo {
            width: 42px;
            height: 42px;
            border-radius: 14px;
            background: var(--gradient);
            display: grid;
            place-items: center;
            color: white;
            box-shadow: 0 8px 20px rgba(212, 0, 0, .18);
        }

        .brand .title {
            font-weight: 800;
            letter-spacing: 0.6px
        }

        .brand .title span {
            opacity: .85;
            font-weight: 700
        }

        .nav {
            height: calc(100% - 72px);
            overflow-y: auto;
            padding: 12px 0px 24px 0px;
            scrollbar-width: thin
        }

        .nav-group {
            margin: 10px 0
        }

        .nav-item {
            list-style: none;
            margin: 8px 0;
            position: relative;
        }

        .link {
            display: flex;
            align-items: center;
            gap: 14px;
            padding: 12px 14px;
            border-radius: 14px;
            color: var(--text);
            text-decoration: none;
            background: transparent;
            transition: background var(--transition-fast), transform var(--transition-fast), color var(--transition-fast);
            outline: none;
            position: relative;
        }

        .link .icon {
            width: 38px;
            height: 38px;
            border-radius: 12px;
            display: grid;
            place-items: center;
            background: var(--glass);
            box-shadow: inset 0 0 0 1px rgba(0, 0, 0, 0.04);
        }

        .link:hover {
            background: rgba(0, 0, 0, 0.06);
            transform: translateY(-1px)
        }

        .link:active {
            transform: translateY(0)
        }

        .link .chev {
            margin-left: auto;
            transition: transform var(--transition-fast)
        }

        .link.active {
            background: rgba(212, 0, 0, 0.18);
            box-shadow: var(--ring)
        }

        .link.active .icon {
            background: rgba(212, 0, 0, 0.22)
        }

        .submenu {
            height: 0;
            overflow: hidden;
            transition: height var(--transition-slow);
            padding-left: 24px
        }

        .submenu a {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 10px 12px;
            border-radius: 12px;
            margin: 6px 0;
            text-decoration: none;
            color: var(--text);
            background: transparent;
        }

        .submenu a:hover {
            background: rgba(0, 0, 0, 0.06)
        }

        /* Remove button border for sidebar dropdowns */
        .sidebar .nav-item > button.link {
            border: none;
            background: transparent;
            box-shadow: none;
            width: 100%;
            text-align: left;
            padding: 12px 14px;
        }

        /* Remove focus/active border for dropdowns */
        .sidebar .nav-item > button.link:focus,
        .sidebar .nav-item > button.link:active {
            border: none;
            box-shadow: none;
            outline: none;
        }
       .rotate {
    transform: rotate(180deg);
}

.link.active {
    background: rgba(212, 0, 0, 0.18);
}

.submenu a.active {
    background: rgba(0, 0, 0, 0.08);
    font-weight: 600;
}

.sidebar {
    grid-row: 1 / span 2;
    height: 100%;
    overflow-y: auto;
}



</style>

<!-- Sidebar -->
        <aside class="sidebar" id="sidebar" aria-label="Sidebar Navigation">
            <!-- Mobile close arrow// -->
            <button class="close-mobile" id="closeSidebarMobile" aria-label="Close sidebar" title="Close sidebar">
                <i class="fa-solid fa-arrow-left"></i>
            </button>
            <div class="brand">
                <div class="logo"><i class="fa-solid fa-users"></i></div>
                <div class="title"><span>CUSTOMER</span> Management</div>
            </div>
            <nav class="nav" id="nav">
                <ul class="nav-group">
          <!-- 0. Dashboard -->
          <li class="nav-item">
            <a class="link has-tooltip" href="index.php" data-page="Dashboard">
              <span class="icon"><i class="fa-solid fa-house"></i></span>
              <span class="text">Dashboard</span>
              <span class="tooltip">Dashboard</span>
            </a>
          </li>
          <!-- 1. Customer Management (Dropdown) -->
         <li class="nav-item">
                        <button class="link has-tooltip" data-toggle="submenu" aria-expanded="false">
                            <span class="icon"><i class="fa-solid fa-users"></i></span>
                            <span class="text" style="font-size: 16px;">Customer Management</span>
                            <!-- <i class="fa-solid fa-chevron-down chev"></i> -->
                            <!-- <span class="tooltip">Customer Management</span> -->
                        </button>
                        <div class="submenu">
                            <a href="customerlist.php" data-page="Add Customer"><i class="fa-solid fa-user-plus"></i>Customer list</a>
                            <a class="link has-tooltip" href="postjob.php" data-page="Customer List"><i class="fa-solid fa-list"></i>Post Job</a>
                            <a class="link has-tooltip" href="applyjob.php" data-page="Customer List"><i class="fa-solid fa-list"></i>Apply Job<span class="text"></span>
                  <!-- <span class="tooltip">Customer List</span> -->
                </a>
                        </div>
                    </li>

          <!-- 2. Customer Renewal -->

          <!-- <li class="nav-item">
            <a class="link has-tooltip" href="customerrenewal.php" data-page="Customer Renewal">
              <span class="icon"><i class="fa-solid fa-rotate-right"></i></span>
              <span class="text">Customer Renewal</span>
              <span class="tooltip">Customer Renewal</span>
            </a>
          </li> -->

          <!-- 3. Renewal List -->

          <!-- <li class="nav-item">
            <a class="link has-tooltip" href="renewallist.php" data-page="Renewal List">
              <span class="icon"><i class="fa-solid fa-list-check"></i></span>
              <span class="text">Renewal List</span>
              <span class="tooltip">Renewal List</span>
            </a>
          </li> -->

          <!-- 4. Reports (Dropdown) -->

          <!-- <li class="nav-item">
            <button class="link has-tooltip" data-toggle="submenu" aria-expanded="false">
              <span class="icon"><i class="fa-solid fa-chart-line"></i></span>
              <span class="text">Reports</span>
              <i class="fa-solid fa-chevron-down chev"></i>
              <span class="tooltip">Reports</span>
            </button>
            <div class="submenu">
              <a class="link has-tooltip" href="recoveryreport.php" data-page="Recovery Report">
                <i class="fa-solid fa-rotate-left"></i>
                <span class="text">Recovery Report</span>
                <span class="tooltip">Recovery Report</span>
              </a>
              <a class="link has-tooltip" href="pendingreport.php" data-page="Pending Report">
                <i class="fa-solid fa-clock"></i>
                <span class="text">Pending Report</span>
                <span class="tooltip">Pending Report</span>
              </a>
              <a class="link has-tooltip" href="reports.php" data-page="General Reports">
                <i class="fa-solid fa-chart-bar"></i>
                <span class="text">General Reports</span>
                <span class="tooltip">General Reports</span>
              </a>
            </div>
          </li> -->
        </ul>
      </nav>
    </aside>
     


   <script>
document.addEventListener("DOMContentLoaded", function () {

    const dropdownButtons = document.querySelectorAll("[data-toggle='submenu']");
    const allSubmenus = document.querySelectorAll(".submenu");

    // =============== DROPDOWN TOGGLE ===================
    dropdownButtons.forEach(btn => {
        btn.addEventListener("click", function () {

            const submenu = btn.nextElementSibling;
            const arrow = btn.querySelector(".chev");

            // Close other submenus EXCEPT this one
            allSubmenus.forEach(sm => {
                if (sm !== submenu) {
                    sm.style.height = "0px";
                    sm.previousElementSibling?.querySelector(".chev")?.classList.remove("rotate");
                }
            });

            // Toggle this submenu
            if (submenu.style.height && submenu.style.height !== "0px") {
                submenu.style.height = "0px";
                arrow.classList.remove("rotate");
            } else {
                submenu.style.height = submenu.scrollHeight + "px";
                arrow.classList.add("rotate");
            }
        });
    });


    // =============== KEEP SUBMENU OPEN WHEN CLICKING INSIDE ===================
    document.querySelectorAll(".submenu a").forEach(link => {
        link.addEventListener("click", function (e) {
            // do NOT hide submenu
            const submenu = link.closest(".submenu");
            submenu.style.height = submenu.scrollHeight + "px";
        });
    });


    // =============== AUTO OPEN ACTIVE PAGE SUBMENU ===================
    const currentPage = window.location.pathname.split("/").pop();

    document.querySelectorAll(".submenu a").forEach(link => {
        if (link.getAttribute("href") === currentPage) {

            // highlight link
            link.classList.add("active");

            // open submenu automatically
            const submenu = link.closest(".submenu");
            submenu.style.height = submenu.scrollHeight + "px";

            // rotate arrow of parent button
            submenu.previousElementSibling.querySelector(".chev").classList.add("rotate");
        }
    });

});
</script>

