
    // ===== Dynamic Header: Clock & Info =====
    
    // Close other dropdowns when opening one (optional polish)
    function closeSiblings(currentBtn){
      dropdownTriggers.forEach(btn => {
        if(btn!==currentBtn){
          const pane = btn.closest('.nav-item').querySelector('.submenu');
          btn.setAttribute('aria-expanded','false');
          btn.classList.remove('active');
          pane.style.height = '0px';
          btn.querySelector('.chev').style.transform = 'rotate(0)';
        }
      })
    }
    dropdownTriggers.forEach(btn => btn.addEventListener('click', () => closeSiblings(btn)));

   
    // ===== Sidebar: collapse & mobile toggle =====
    const app = document.getElementById('app');
    const sidebar = document.getElementById('sidebar');
    const sidebarToggle = document.getElementById('sidebarToggle');
    const collapseToggle = document.getElementById('collapseToggle');
    const closeSidebarMobile = document.getElementById('closeSidebarMobile');

    // Mobile open/close
    sidebarToggle.addEventListener('click', () => {
      if(window.matchMedia('(max-width: 860px)').matches){
        sidebar.classList.toggle('open');
      } else {
        app.classList.toggle('collapsed');
      }
    });

    // Collapse for wide screens
    collapseToggle.addEventListener('click', () => {
      app.classList.toggle('collapsed');
    });

    // Mobile close arrow
    closeSidebarMobile.addEventListener('click', () => {
      sidebar.classList.remove('open');
    });

    // Close mobile sidebar when clicking main area
    document.getElementById('main').addEventListener('click', () => {
      if(window.matchMedia('(max-width: 860px)').matches){
        sidebar.classList.remove('open');
      }
    })

    // ===== Keyboard shortcut for search focus =====
    const searchInput = document.querySelector('.header .search input');
    window.addEventListener('keydown', (e) => {
      if(e.key === '/' && document.activeElement !== searchInput){
        e.preventDefault(); searchInput.focus();
      }
    });

    // ===== Mock data for chart & table =====
    const barChart = document.getElementById('barChart');
    const days = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'];
    const values = [42, 64, 58, 90, 105, 70, 84];
    const maxVal = Math.max(...values);
    barChart.innerHTML = values.map((v, i) => {
        const h = 40 + Math.round((v / maxVal) * 100); // normalized height 40-140
        return `<div class="bar" style="height:${h}px" data-label="${days[i]}"></div>`
    }).join('');

    const customersTbody = document.getElementById('customersTbody');
    const sampleCustomers = [
        { id: 'CUS-12098', name: 'Ayesha Khan', email: 'ayesha@example.com', phone: '+92 300 1234567', status: 'Active' },
        { id: 'CUS-12099', name: 'Ahmed Ali', email: 'ahmed@example.com', phone: '+92 301 2345678', status: 'Active' },
        { id: 'CUS-12100', name: 'Sana Raza', email: 'sana@example.com', phone: '+92 302 3456789', status: 'VIP' },
        { id: 'CUS-12101', name: 'Bilal Iqbal', email: 'bilal@example.com', phone: '+92 303 4567890', status: 'Pending Renewal' },
        { id: 'CUS-12102', name: 'Hira Nawaz', email: 'hira@example.com', phone: '+92 304 5678901', status: 'Recovered' },
    ];
    function renderCustomersTable() {
        // Responsive table: add data-label for mobile
        const labels = ['Customer ID', 'Name', 'Email', 'Phone', 'Status', 'Actions'];
        customersTbody.innerHTML = sampleCustomers.map(c => {
            let statusClass = 'success';
            if (c.status === 'Pending Renewal') statusClass = 'pending';
            if (c.status === 'Recovered') statusClass = 'failed';
            
            return `
          <tr>
            <td data-label="${labels[0]}">${c.id}</td>
            <td data-label="${labels[1]}">${c.name}</td>
            <td data-label="${labels[2]}">${c.email}</td>
            <td data-label="${labels[3]}">${c.phone}</td>
            <td data-label="${labels[4]}">
              <span class="status ${statusClass}">${c.status}</span>
            </td>
            <td data-label="${labels[5]}">
              <div class="customer-table-actions">
                <button class="view" title="View"><i class="fa-solid fa-eye"></i></button>
                <button class="edit" title="Edit"><i class="fa-solid fa-pen"></i></button>
                <button class="delete" title="Delete"><i class="fa-solid fa-trash"></i></button>
              </div>
            </td>
          </tr>
        `}).join('');
    }
    renderCustomersTable();

    // ===== Demo content changer on nav click =====
    function simulateContent(page){
      const infoMap = {
        'Dashboard': 'Customer insights and management dashboard',
        'Customer Management': 'Add, edit and manage customer profiles',
        'Customer Renewal': 'Manage customer renewal processes',
        'Renewal List': 'View and manage pending customer renewals',
        'Reports': 'Customer analytics and performance metrics',
        'Recovery Report': 'View customer recovery statistics and trends',
        'Pending Report': 'Monitor pending customer actions and requests',
      };
      headerInfo.textContent = infoMap[page] || 'Customer insights and management dashboard';
    }

    // Ensure collapsed tooltips show when sidebar is collapsed
    const appObserver = new MutationObserver(() => {
      const collapsed = app.classList.contains('collapsed');
      document.querySelectorAll('.has-tooltip .tooltip').forEach(t => t.style.display = collapsed ? 'block' : 'none');
      document.querySelectorAll('.has-tooltip .text').forEach(t => t.style.display = collapsed ? 'none' : 'inline');
    });
    appObserver.observe(app, { attributes: true, attributeFilter: ['class'] });

    // Initialize tooltip visibility state
    (function initCollapsedState(){
      const collapsed = app.classList.contains('collapsed');
      document.querySelectorAll('.has-tooltip .tooltip').forEach(t => t.style.display = collapsed ? 'block' : 'none');
      document.querySelectorAll('.has-tooltip .text').forEach(t => t.style.display = collapsed ? 'none' : 'inline');
    })();

    // Accessibility niceties: close dropdowns on Escape
    window.addEventListener('keydown', (e) => {
      if(e.key === 'Escape'){
        dropdownTriggers.forEach(btn => btn.click());
        sidebar.classList.remove('open');
      }
    });

    // Add event listeners to navigation items
    document.querySelectorAll('.nav a').forEach(link => {
      link.addEventListener('click', function(e) {
        // Update active state
        document.querySelectorAll('.nav a').forEach(a => a.classList.remove('active'));
        this.classList.add('active');
        
        // Update page content
        const page = this.getAttribute('data-page');
        document.getElementById('pageTitle').textContent = page;
        simulateContent(page);
      });
    });
